<?php

use App\Http\Controllers\Admin\AnuncioController;
use App\Http\Controllers\Admin\CategoriaController;
use App\Http\Controllers\Admin\EventoController;
use App\Http\Controllers\Admin\HomeController;
use App\Http\Controllers\Admin\LojaController;
use App\Http\Controllers\Admin\PotenciaController;
use App\Http\Controllers\Admin\ServicoController;
use App\Http\Controllers\Admin\SubCategoriaController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\PerguntasController;
use App\Http\Controllers\Admin\SlideController;
use App\Http\Controllers\Aplicativo\AppAnuncioController;
use App\Http\Controllers\Aplicativo\AppController;
use App\Http\Controllers\Aplicativo\AppUserController;
use App\Http\Controllers\Aplicativo\FiltroController;
use App\Http\Controllers\CategoriasNovasController;
use App\Http\Controllers\ChatBotController;
use App\Http\Controllers\ContatoController;
use App\Http\Controllers\DebugController;
use App\Http\Controllers\TrabalhoMaconico;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;

Route::get('/', [AppController::class, 'index'])->name('app.home');


Route::group(['prefix' => 'admin', 'middleware' => 'auth'], function () {
    Route::get('/', [HomeController::class, 'index'])->middleware(['auth'])->name('admin.home');

    //CATEGORIAS
    Route::get('/categorias', [CategoriaController::class, 'index'])->name('categorias.index');
    Route::post('/categorias', [CategoriaController::class, 'store'])->name('categoria.store');
    Route::post('/categoria', [CategoriaController::class, 'update'])->name('categoria.update');
    Route::post('/categoria/get-level1', [CategoriaController::class, 'GetLevel1'])->name('get.level1');
    Route::post('/categoria/level1-destroy', [CategoriaController::class, 'DestroyLevel1'])->name('level1.destroy');


    //SUB CATEGORIAS
    Route::get('/sub-categorias/{id}', [SubCategoriaController::class, 'index'])->name('sub.categorias.index');
    Route::post('/sub-categorias', [SubCategoriaController::class, 'store'])->name('sub.categoria.store');
    Route::post('/sub-categoria/{id}', [SubCategoriaController::class, 'update'])->name('sub.categoria.update');
    Route::post('/categoria/get-level2', [CategoriaController::class, 'GetLevel2'])->name('get.level2');
    Route::post('/categoria/level2-destroy', [CategoriaController::class, 'DestroyLevel2'])->name('level2.destroy');

    //ANUNCIOS
    Route::get('/anuncios', [AnuncioController::class, 'anuncios'])->name('todos.anuncios');
    Route::post('/buscar', [AnuncioController::class, 'buscar'])->name('buscar');
    Route::get('/anuncios/categoria/{level1_id}', [AnuncioController::class, 'AnunciosCategoria'])->name('anuncios.categoria');
    Route::get('/anuncios/categoria/sub/{level1_id}/{level2_id}', [AnuncioController::class, 'AnunciosCategoriaSub'])->name('anuncios.categoria.sub');
    Route::get('/anuncios-patrocinados', [AnuncioController::class, 'patrocinados'])->name('anuncios.patrocinados');
    Route::get('/anuncios-free', [AnuncioController::class, 'free'])->name('anuncios.free');
    Route::get('/anuncio/create', [AnuncioController::class, 'create'])->name('anuncio.create');
    Route::post('/anuncios/store', [AnuncioController::class, 'store'])->name('anuncio.store');
    Route::get('/anuncio/{id}', [AnuncioController::class, 'show'])->name('anuncio.show');
    Route::post('/anuncio/update/{id}', [AnuncioController::class, 'update'])->name('anuncio.update');
    Route::get('/anuncio-destroy/{id}', [AnuncioController::class, 'destroy'])->name('anuncio.destroy');
    Route::get('/anuncio-duplicar/{id}', [AnuncioController::class, 'duplicar'])->name('anuncio.duplicar');

    //USUÁRIOS
    Route::get('/users', [UserController::class, 'index'])->name('user.index');
    Route::get('/user/{id}', [UserController::class, 'show'])->name('user.show');
    Route::get('/user-create', [UserController::class, 'create'])->name('user.create');
    Route::post('/user-create', [UserController::class, 'store'])->name('user.store');
    Route::post('/user-update/{id}', [UserController::class, 'update'])->name('user.update');

    //POTENCIAS
    Route::get('/potencias', [PotenciaController::class, 'index'])->name('potencias.index');
    Route::get('/potencia/create', [PotenciaController::class, 'create'])->name('potencia.create');
    Route::post('/potencia/store', [PotenciaController::class, 'store'])->name('potencia.store');
    Route::get('/potencia/{id}', [PotenciaController::class, 'show'])->name('potencia.show');
    Route::post('/potencia/update/{id}', [PotenciaController::class, 'update'])->name('potencia.update');
    Route::get('/potencia/destroy/{id}', [PotenciaController::class, 'destroy'])->name('potencia.destroy');

    //LOJAS
    Route::get('/lojas', [LojaController::class, 'index'])->name('lojas.index');
    Route::post('/lojas', [LojaController::class, 'buscar'])->name('buscar.lojas');
    Route::get('/lojas/potencia/{id}', [LojaController::class, 'lojas'])->name('lojas.potencia');
    Route::get('/lojas/create', [LojaController::class, 'create'])->name('loja.create');
    Route::post('/lojas/store', [LojaController::class, 'store'])->name('loja.store');
    Route::get('/loja/show/{id}', [LojaController::class, 'show'])->name('loja.show');
    Route::post('/lojas/update/{id}', [LojaController::class, 'update'])->name('loja.update');
    Route::get('/lojas/destroy/{id}', [LojaController::class, 'destroy'])->name('loja.destroy');
    Route::post('/add-telefone-loja', [LojaController::class, 'AddTelefone'])->name('add.telefone.lojas');
    Route::post('/remove-telefone-loja', [LojaController::class, 'RemoveTelefone'])->name('remove.telefone.loja');

    //EVENTOS
    Route::get('/eventos', [EventoController::class, 'index'])->name('eventos.index');
    Route::get('/evento/create', [EventoController::class, 'create'])->name('evento.create');
    Route::post('/evento/store', [EventoController::class, 'store'])->name('evento.store');
    Route::get('/evento/{id}', [EventoController::class, 'show'])->name('evento.show');
    Route::post('/evento/update/{id}', [EventoController::class, 'update'])->name('evento.update');
    Route::get('/evento/destroy/{id}', [EventoController::class, 'destroy'])->name('evento.destroy');

    //PERGUNTAS FREQUENTES
    Route::get('/perguntas-frequentes', [PerguntasController::class, 'index'])->name('perguntas.index');
    Route::get('/perguntas-frequentes/create', [PerguntasController::class, 'create'])->name('perguntas.create');
    Route::post('/perguntas-frequentes/store', [PerguntasController::class, 'store'])->name('perguntas.store');
    Route::get('/perguntas-frequentes/{id}', [PerguntasController::class, 'show'])->name('perguntas.show');
    Route::post('/perguntas-frequentes/update/{id}', [PerguntasController::class, 'update'])->name('perguntas.update');
    Route::get('/perguntas-frequentes/destroy/{id}', [PerguntasController::class, 'destroy'])->name('perguntas.destroy');

    //SLIDES
    Route::get('/slides', [SlideController::class, 'index'])->middleware(['auth'])->name('slides.index');
    Route::get('/slide/create', [SlideController::class, 'create'])->middleware(['auth'])->name('slide.create');
    Route::post('/slide/create', [SlideController::class, 'store'])->middleware(['auth'])->name('slide.store');
    Route::get('/slide/show/{id}', [SlideController::class, 'show'])->middleware(['auth'])->name('slide.show');
    Route::post('/slide/update/{id}', [SlideController::class, 'update'])->middleware(['auth'])->name('slide.update');
    Route::get('/slide/destroy/{id}', [SlideController::class, 'destroy'])->middleware(['auth'])->name('slide.destroy');


    //CATEGORIAS NOVAS
    Route::get('/categorias/novas/index', [CategoriasNovasController::class, 'index'])->name('categorias.novas.index');

    //RABIN
    Route::get('/rabin/{contrato}', [AnuncioController::class, 'rabin']);

    Route::get('/trabalhos-maconicos', [TrabalhoMaconico::class, 'index'])->name('trabalhos');
    Route::post('/trabalho-store', [TrabalhoMaconico::class, 'store'])->name('trabalho.store');
    Route::get('/trabalho-destroy/{id}', [TrabalhoMaconico::class, 'destroy'])->name('trabalho.destroy');
});

//SERVIÇOS
Route::get('/servicos/index', [ServicoController::class, 'index'])->middleware('auth')->name('servicos.index');
Route::get('/servicos/create', [ServicoController::class, 'create'])->middleware('auth')->name('servicos.create');
Route::post('/servicos/store', [ServicoController::class, 'store'])->middleware('auth')->name('servico.store');
Route::get('/servico/edit/{id}', [ServicoController::class, 'edit'])->middleware('auth')->name('servico.edit');
Route::post('/servico/edit/{id}', [ServicoController::class, 'update'])->middleware('auth')->name('servico.update');

//PERFIL
Route::get('/meus-dados', [UserController::class, 'MeusDados'])->middleware(['auth'])->name('meus.dados');
Route::post('/update-foto', [UserController::class, 'UpdateFoto'])->middleware(['auth'])->name('update.foto');
Route::post('/update-perfil', [UserController::class, 'UpdatePerfil'])->middleware(['auth'])->name('update.perfil');
Route::get('/minhas-comissoes', [ComissoesController::class, 'Comissoes'])->middleware(['auth'])->name('minhas.comissoes');

//ROTAS AJAX
Route::post('/get-categorias', [CategoriaController::class, 'GetCategorias'])->name('get.categorias');
Route::post('/add-telefone', [AnuncioController::class, 'AddTelefone'])->name('add.telefone');
Route::post('/add-socio', [AnuncioController::class, 'AddSocio'])->name('add.socio');
Route::post('/remove-telefone', [AnuncioController::class, 'RemoveTelefone'])->name('remove.telefone');
Route::post('/remove-socio', [AnuncioController::class, 'RemoveSocio'])->name('remove.socio');
Route::post('/consulta', [AnuncioController::class, 'ConsultaCNPJ'])->name('consulta.cnpj');

Route::get('/storage-link', function () {
    Artisan::call('storage:link');
});


// Route::get('/home/{estado}/{cidade}/', [AppController::class, 'home'])->name('home.home');
// Route::get('/quem-somos', [AppController::class, 'quemsomos'])->name('app.quem.somos');
// Route::get('/filtros', [FiltroController::class, 'filtros'])->name('app.filtros');
// Route::post('/get-cidades', [FiltroController::class, 'getCidades'])->name('get.cidades');
// Route::post('/filtro-categorias', [FiltroController::class, 'FiltroCategorias'])->name('filtro.categorias');
// Route::post('/filtro-sub-cat', [FiltroController::class, 'FiltroSubCat'])->name('filtro.sub.cat');
// Route::post('/filtro-full', [FiltroController::class, 'FiltroFull'])->name('filtro.full');
// Route::post('/filtrar', [FiltroController::class, 'filtrar'])->name('filtrar');
// Route::get('/categorias/{estado}/{cidade}', [AppController::class, 'categorias'])->name('app.categorias');
// Route::get('/anuncios/categoria/{id}/{estado}/{cidade}', [AppController::class, 'categoria'])->name('app.anuncios.categoria');
// Route::get('/categorias-level2/{level1_id}/{level2_id}/{estado}/{cidade}', [AppController::class, 'CategoriaLevel2'])->name('app.categoria.level2');

// Route::get('/contato', [AppController::class, 'contato'])->name('app.contato');
// Route::post('/contato', [ContatoController::class, 'store'])->name('app.contato.store');

// Route::get('/fundadores', [AppController::class, 'fundadores'])->name('app.fundadores');
// Route::get('/perguntas-frequetes', [AppController::class, 'perguntas'])->name('app.perguntas');

// //PERFIL USUÁRIO
// Route::get('/meu-perfil', [AppUserController::class, 'perfil'])->middleware('auth')->name('meu.perfil');
// Route::post('/update-foto', [UserController::class, 'UpdateFoto'])->middleware(['auth'])->name('update.foto');
// Route::post('/perfil/{id}', [UserController::class, 'UpdatePerfilApp'])->middleware(['auth'])->name('update.perfil.app');

// //ACNUNCIOS
Route::get('/anuncio/{id}', [AppAnuncioController::class, 'anuncio'])->name('app.anuncio');
Route::get('/arte/{contrato}', [AppAnuncioController::class, 'arte']);
Route::post('/ligar', [AppAnuncioController::class, 'Ligar'])->name('app.ligar');
// Route::post('/add-favorito', [AppAnuncioController::class, 'AddFavorito'])->name('app.add.favorito');
// Route::post('/dell-favorito', [AppAnuncioController::class, 'DellFavorito'])->name('app.dell.favorito');
// Route::get('/anunciar', [AppAnuncioController::class, 'anunciar'])->middleware('auth')->name('app.anunciar');
// Route::get('/editar-anunco/{id}', [AppAnuncioController::class, 'EditarAnuncio'])->middleware('auth')->name('app.editar.anuncio');
// Route::post('/atualizar-anunco/{id}', [AppAnuncioController::class, 'UpdateAnuncio'])->middleware('auth')->name('app.update.anuncio');

// //POTENCIAS
// Route::get('/potencia-estados', [AppController::class, 'PotenciaEstados'])->name('app.potencias.estados');
// Route::get('/potencia/{estado}', [AppController::class, 'potencias'])->name('app.potencias');
// Route::get('/lojas-cidades/{potencia}', [AppController::class, 'LojasCidades'])->name('app.lojas.cidades');
// Route::get('/lojas/{oriente}/{potencia}', [AppController::class, 'lojas'])->name('app.lojas');
// Route::get('/loja/{id}', [AppController::class, 'loja'])->name('app.loja');

// //EVENTOS 
// Route::get('/eventos', [AppController::class, 'eventos'])->name('app.eventos');
// Route::get('/evento/{id}', [AppController::class, 'evento'])->name('app.evento');

// //COMBO HOME FILTRO INICIAL
// Route::post('/get-cidade', [AppController::class, 'getCidades'])->name('get.cidade');
// Route::post('/busca-rapida', [AppController::class, 'busca'])->name('busca.rapida');
// Route::post('/get-lojas', [AppController::class, 'GetLojas'])->name('get.lojas');
Route::post('/trolhamento', [AppController::class, 'trolhamento'])->name('trolhamento');


//CHATBOT
Route::get('/aniversariantes', [ChatBotController::class, 'aniversariantes']);
Route::get('/marketing', [ChatBotController::class, 'marketing'])->name('marketing');
Route::get('time/{id}',[ChatBotController::class,'time'])->name('time');
Route::post('marketing-update',[ChatBotController::class,'MarketingUpdate'])->name('marketing.update');


Route::get('/debug', [DebugController::class, 'debug']);


require __DIR__ . '/auth.php';
