@extends('site.base')
@section('description')
    {{ env('APP_EMPRESA') }} {{$servico->descricao}}
@endsection
@section('keywords')
     {{ env('APP_EMPRESA') }} {{$servico->titulo}}
@endsection

@section('content')
<section class="section breadcrumb-area bg-overlay d-flex align-items-center">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="breadcrumb-content text-center">
                    <h2 class="text-white text-capitalize">{{$servico->titulo}}</h2>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ***** Breadcrumb Area End ***** -->

<!-- ***** Blog Area Start ***** -->
<section id="blog" class="section blog-area ptb_100">
    <div class="container">
        <div class="row">
            <div class="col-12 col-lg-9">
                 <article class="single-blog-details">
                    <div class="blog-thumb">
                        <a href="#"><img src="{{url("storage/{$servico->image}")}}" alt=""></a>
                    </div>
                    <div class="blog-content sApp-blog">
                        <div class="blog-details">
                            <h3 class="blog-title py-2 py-sm-3"><a href="#">{{$servico->titulo}}</a></h3>
                            {!!$servico->descricao!!}
                        </div>
                    </div>
                </article>
            </div>
            <div class="col-12 col-lg-3">
                <aside class="sidebar pt-5 pt-lg-0">
                    <div class="single-widget">
                        <div class="accordions widget catagory-widget" id="cat-accordion">
                            <div class="single-accordion blog-accordion">
                                <h5>
                                    <a role="button" class="collapse show text-uppercase d-block p-3" data-toggle="collapse" href="#accordion1">Outros Serviços
                                    </a>
                                </h5>
                                <div id="accordion1" class="accordion-content widget-content collapse show" data-parent="#cat-accordion">
                                    <ul class="widget-items">
                                        @foreach ($servicos as $item)
                                            <li><a href="{{route('site.servico',$item->url)}}" class="d-flex p-3"><span>{{$item->titulo}}</span></a></li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>
@endsection
