@extends('site.base')
@section('description')
    {{ env('APP_DESCRIPTION') }}
@endsection
@section('keywords')
{{ env('APP_KEYWORDS') }}
@endsection

@section('content')
    <!-- ***** Welcome Area Start ***** -->
    <section id="home" class="section welcome-area bg-overlay d-flex align-items-center">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <!-- Welcome Intro Start -->
                <div class="col-12 col-lg-7">
                    <div class="welcome-intro">
                        <h1 class="text-white">Fisioterapia Domiciliar</h1>
                        <p class="text-white my-4">Atendimento de fisioterapia domiciliar em Salvador e Região
                            Metropolitana</p>
                        <!-- Store Buttons -->
                        <div class="button-group store-buttons d-flex">
                            <a href="{{ url('site') }}/#" class="btn sApp-btn text-uppercase">Agende Seu
                                Atendimento</a>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-md-8 col-lg-5">
                    <!-- Contact Box -->
                    <div class="contact-box bg-white text-center rounded p-4 p-sm-5 mt-5 mt-lg-0 shadow-lg">
                        <!-- Contact Form -->
                        <form id="contact-form">
                            <div class="contact-top">
                                <h3 class="contact-title">Solicite uma avaliação gratuita</h3>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="nome" id="nome" placeholder="Como se chama?" required="required">
                                    </div>
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="descricao" id="descricao" placeholder="Descreva rápidamente sua necessidade" required="required">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <button id="iniciar" class="btn btn-bordered w-100 mt-3 mt-sm-4" type="button">Iniciar</button>
                                </div>
                            </div>
                        </form>
                        <p class="form-message"></p>
                    </div>
                </div>
            </div>
        </div>
        <!-- Shape Bottom -->
        <div class="shape-bottom">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 100" preserveAspectRatio="none">
                <path class="shape-fill" fill="#FFFFFF"
                    d="M421.9,6.5c22.6-2.5,51.5,0.4,75.5,5.3c23.6,4.9,70.9,23.5,100.5,35.7c75.8,32.2,133.7,44.5,192.6,49.7  c23.6,2.1,48.7,3.5,103.4-2.5c54.7-6,106.2-25.6,106.2-25.6V0H0v30.3c0,0,72,32.6,158.4,30.5c39.2-0.7,92.8-6.7,134-22.4  c21.2-8.1,52.2-18.2,79.7-24.2C399.3,7.9,411.6,7.5,421.9,6.5z">
                </path>
            </svg>
        </div>
    </section>
    <!-- ***** Welcome Area End ***** -->

   <section id="sobre" class="section features-area overflow-hidden ptb_100">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12 col-md-10 col-lg-8">
                    <!-- Section Heading -->
                    <div class="section-heading text-center">
                        <h2>Sobre a {{env('APP_EMPRESA')}}</h2>
                        <p class="d-none d-sm-block mt-4">
                            A {{env('APP_EMPRESA')}} é uma empresa com o objetivo de prestar serviços de qualidade aos seus pacientes, com profissionais capacitados, tecnologia, estrutura completa e equipe multiprofissional - integração das áreas para o melhor tratamento.
                        </p>
                        <p class="d-none d-sm-block mt-4">
                            Todo nosso atendimento é Residencial (Home Care), com atendimentos individuais, incluindo tambem essoas portadoras de deficiência. Todos os tratamentos oferecidos são baseados em métodos científicos, respeitando as particularidades de cada um.
                        </p>
                        <p class="d-none d-sm-block mt-4">
                            A Drª Ingrid Brito é uma Fisioterapeuta especializada em fornecer tratamento de qualidade e excelência com soluções para reabilitação de homens e mulheres.
                        </p>
                    </div>
                </div>
            </div>
            <div class="row align-items-center">
                <div class="col-12 col-md-6 col-lg-4">
                    <!-- Features Item -->
                    <ul class="features-item">
                        <li>
                            <!-- Image Box -->
                            <div class="image-box media px-1 py-3 py-md-4 wow fadeInLeft" data-aos-duration="2s" data-wow-delay="0.3s">
                                <!-- Featured Image -->
                                <div class="featured-img mr-3">
                                    <img class="avatar-sm" src="{{url('site/assets/img/physical-therapy.png')}}" alt="">
                                </div>
                                <!-- Icon Text -->
                                <div class="icon-text media-body align-self-center align-self-md-start">
                                    <h3 class="mb-2">Fisioterapia</h3>
                                    <p>Fisioterapia Respiratória, Fisioterapia Neurológica, Fisioterapia Geriátrica, Fisioterapia Ortopédica </p>
                                </div>
                            </div>
                        </li>
                        <li>
                            <!-- Image Box -->
                            <div class="image-box media px-1 py-3 py-md-4 wow fadeInLeft" data-aos-duration="2s" data-wow-delay="0.6s">
                                <!-- Featured Image -->
                                <div class="featured-img mr-3">
                                    <img class="avatar-sm" src="{{url('site/assets/img/orthopedics.png')}}" alt="">
                                </div>
                                <!-- Icon Text -->
                                <div class="icon-text media-body align-self-center align-self-md-start">
                                    <h3 class="mb-2">Ortopédia</h3>
                                    <p>Trata lesões e disfunções que envolvem tendões, articulações e músculos, além de doenças ortopédicas.</p>
                                </div>
                            </div>
                        </li>
                        <li>
                            <!-- Image Box -->
                            <div class="image-box media px-1 py-3 py-md-4 wow fadeInLeft" data-aos-duration="2s" data-wow-delay="0.9s">
                                <!-- Featured Image -->
                                <div class="featured-img mr-3">
                                    <img class="avatar-sm" src="{{url('site/assets/img/rehabilitation.png')}}"  alt="">
                                </div>
                                <!-- Icon Text -->
                                <div class="icon-text media-body align-self-center align-self-md-start">
                                    <h3 class="mb-2">Reabilitação</h3>
                                    <p>A Reabilitação Funcional atua na área da disfunção do paciente através de exercícios controlados, atividades focadas na coordenação entre partes do corpo, treinamento de força, flexibilidade e agilidade, visando preparar o indivíduo para voltar à sua vida cotidiana.</p>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="col-12 col-lg-4 d-none d-lg-block">
                    <!-- Featutes Thumb -->
                    <div class="features-thumb text-center">
                        <img src="{{url('site/assets/img/dra-ingrid-brito.png')}}" alt="Drª Ingrid Brito CEO Home Physio">
                        <h3 class="mb-2">Drª Ingrid Brito</h3>
                    </div>
                </div>
                <div class="col-12 col-md-6 col-lg-4">
                    <!-- Features Item -->
                    <ul class="features-item">
                        <li>
                            <!-- Image Box -->
                            <div class="image-box media px-1 py-3 py-md-4 wow fadeInRight" data-aos-duration="2s" data-wow-delay="0.3s">
                                <!-- Featured Image -->
                                <div class="featured-img mr-3">
                                    <img class="avatar-sm" src="{{url('site/assets/img/dumbbell.png')}}" alt="">
                                </div>
                                <!-- Icon Text -->
                                <div class="icon-text media-body align-self-center align-self-md-start">
                                    <h3 class="mb-2">Fortalecimeto</h3>
                                    <p>Atividade que tem por finalidade manter musculatura melhor condicionada, permitindo realizar as mais variadas atividades do dia a dia com mais segurança e autonomia. Uma musculatura forte e resistente é sinônimo de mais saúde.</p>
                                </div>
                            </div>
                        </li>
                        <li>
                            <!-- Image Box -->
                            <div class="image-box media px-1 py-3 py-md-4 wow fadeInRight" data-aos-duration="2s" data-wow-delay="0.9s">
                                <!-- Featured Image -->
                                <div class="featured-img mr-3">
                                    <img class="avatar-sm" src="{{url('site/assets/img/old-man.png')}}" alt="">
                                </div>
                                <!-- Icon Text -->
                                <div class="icon-text media-body align-self-center align-self-md-start">
                                    <h3 class="mb-2">Idosos</h3>
                                    <p>Área da fisioterapia voltada para a funcionalidade do corpo de idosos, geralmente, com mais de 65 anos.</p>
                                </div>
                            </div>
                        </li>
                        <li>
                            <!-- Image Box -->
                            <div class="image-box media px-1 py-3 py-md-4 wow fadeInRight" data-aos-duration="2s" data-wow-delay="0.9s">
                                <!-- Featured Image -->
                                <div class="featured-img mr-3">
                                    <img class="avatar-sm" src="{{url('site/assets/img/cupping.png')}}" alt="">
                                </div>
                                <!-- Icon Text -->
                                <div class="icon-text media-body align-self-center align-self-md-start">
                                    <h3 class="mb-2">Terapias Manuais</h3>
                                    <p>Os recursos terapêuticos manuais permitem ao fisioterapeuta avaliar e sentir melhor os movimentos e a qualidade deles, assim como a palpação dos tecidos musculoesqueléticos. As informações são parte importante do processo avaliativo.</p>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

   <!-- ***** Features Area Start ***** -->
   <section id="features" class="section features-area style-two overflow-hidden ptb_100">
       <div class="container">
           <div class="row">
               <div class="col-12 col-md-10 col-lg-7">
                   <!-- Section Heading -->
                   <div class="section-heading">
                       <span class="d-inline-block rounded-pill shadow-sm fw-5 px-4 py-2 mb-3">
                           <i class="far fa-lightbulb text-primary mr-1"></i>
                           <span class="text-primary">Nossa Empresa </span> e nossos Serviços
                       </span>
                       <h2>O Que Fazemos?</h2>
                       <p class="d-none d-sm-block mt-4">A <strong>{{ env('APP_EMPRESA') }}</strong> oferece
                           serviços em fisioterapia ortopédica, respiratória, neurológica, pediátrica e
                           geriátrica. Conta com equipamentos tecnológicos para intervenções terapêuticas mais
                           eficazes, com redução no tempo de tratamento.</p>
                   </div>
               </div>
           </div>
           <div class="row">
               <div class="col-12 col-md-6 col-lg-4 my-3 res-margin">
                   <div class="image-box text-center icon-1 p-5 wow fadeInLeft" data-aos-duration="2s"
                       data-wow-delay="0.4s">
                       <div class="featured-img mb-3">
                           <img class="avatar-sm"
                               src="{{ url('site') }}/assets/img/icon/medical-checkup.png" alt="">
                       </div>
                       <div class="icon-text">
                           <h3 class="mb-2">Atendimento Personalizado</h3>
                           <p>Os melhores equipamentos associados a condutas elaboradas para solução definitiva
                               do seu problema.</p>
                       </div>
                   </div>
               </div>
               <div class="col-12 col-md-6 col-lg-4 my-3 res-margin">
                   <!-- Image Box -->
                   <div class="image-box text-center icon-1 p-5 wow fadeInUp" data-aos-duration="2s"
                       data-wow-delay="0.2s">
                       <!-- Featured Image -->
                       <div class="featured-img mb-3">
                           <img class="avatar-sm" src="{{ url('site') }}/assets/img/icon/doctor.png"
                               alt="">
                       </div>
                       <!-- Icon Text -->
                       <div class="icon-text">
                           <h3 class="mb-2">Fisioterapeuta Certificada</h3>
                           <p>A Drª Ingrid Brito, possui Bacharelado em Fisioterapia e Pós Graduação em UTI
                               Fisioterapica</p>
                       </div>
                   </div>
               </div>
               <div class="col-12 col-md-6 col-lg-4 my-3 res-margin">
                   <!-- Image Box -->
                   <div class="image-box text-center icon-1 p-5 wow fadeInRight" data-aos-duration="2s"
                       data-wow-delay="0.4s">
                       <!-- Featured Image -->
                       <div class="featured-img mb-3">
                           <img class="avatar-sm"
                               src="{{ url('site') }}/assets/img/icon/house-cleaning.png" alt="">
                       </div>
                       <!-- Icon Text -->
                       <div class="icon-text">
                           <h3 class="mb-2">Fisioterapia Domiciliar</h3>
                           <p>Após a avaliação iniciaremos seu atendimento profissional personalizado no
                               conforto da sua casa.</p>
                       </div>
                   </div>
               </div>
               <div class="col-12 col-md-6 col-lg-4 my-3 res-margin">
                   <!-- Image Box -->
                   <div class="image-box text-center icon-1 p-5 wow fadeInLeft" data-aos-duration="2s"
                       data-wow-delay="0.8s">
                       <!-- Featured Image -->
                       <div class="featured-img mb-3">
                           <img class="avatar-sm"
                               src="{{ url('site') }}/assets/img/icon/medical-team.png" alt="">
                       </div>
                       <!-- Icon Text -->
                       <div class="icon-text">
                           <h3 class="mb-2">Profissionais Parceiros</h3>
                           <p>A {{ env('APP_EMPRESA') }} conta com uma equipe de profissionais para obter a
                               melhor solução para seu tratamento.</p>
                       </div>
                   </div>
               </div>
               <div class="col-12 col-md-6 col-lg-4 my-3 res-margin">
                   <!-- Image Box -->
                   <div class="image-box text-center icon-1 p-5 wow fadeInUp" data-aos-duration="2s"
                       data-wow-delay="0.4s">
                       <!-- Featured Image -->
                       <div class="featured-img mb-3">
                           <img class="avatar-sm"
                               src="{{ url('site') }}/assets/img/icon/google-docs.png" alt="">
                       </div>
                       <!-- Icon Text -->
                       <div class="icon-text">
                           <h3 class="mb-2">Emissão de Nota Fiscal</h3>
                           <p>Todos os nossos serviços, são acompanhados da emissão da nota fiscal de serviço.
                           </p>
                       </div>
                   </div>
               </div>
               <div class="col-12 col-md-6 col-lg-4 my-3">
                   <!-- Image Box -->
                   <div class="image-box text-center icon-1 p-5 wow fadeInRight" data-aos-duration="2s"
                       data-wow-delay="0.8s">
                       <!-- Featured Image -->
                       <div class="featured-img mb-3">
                           <img class="avatar-sm" src="{{ url('site') }}/assets/img/icon/refund.png"
                               alt="">
                       </div>
                       <!-- Icon Text -->
                       <div class="icon-text">
                           <h3 class="mb-2">Reembolso para planos de Saúde</h3>
                           <p>Toda documentação necessária para a solicitação de reembolso junto ao plano de
                               saúde são emitidas para que o paciente consiga fazer a solicitação.</p>
                       </div>
                   </div>
               </div>
           </div>
       </div>
   </section>
   <!-- ***** Features Area End ***** -->

   <!-- ***** Discover Area Start ***** -->
   <section class="section discover-area bg-gray overflow-hidden ptb_100">
       <div class="container">
           <div class="row justify-content-between">
               <div class="col-12 col-lg-6 order-2 order-lg-1">
                   <!-- Discover Thumb -->
                   <div class="service-thumb discover-thumb mx-auto pt-5 pt-lg-0">
                       <img src="{{ url('site') }}/assets/img/discover/iphone_x.png" alt="">
                   </div>
               </div>
               <div class="col-12 col-lg-6 order-1 order-lg-2">
                   <!-- Discover Text -->
                   <div class="discover-text pt-4 pt-lg-0">
                       <h2 class="pb-4 pb-sm-0">Aplicativo de Atendimento</h2>
                       <p class="d-none d-sm-block pt-3 pb-4">Baixe nosso aplicativo e faça sua avaliação
                           gratuiramente</p>
                       <!-- Check List -->
                       <ul class="check-list">
                           <li class="py-1">
                               <!-- List Box -->
                               <div class="list-box media">
                                   <span class="icon align-self-center"><i class="fas fa-check"></i></span>
                                   <span class="media-body pl-3">Avaliação</span>
                               </div>
                           </li>
                           <li class="py-1">
                               <!-- List Box -->
                               <div class="list-box media">
                                   <span class="icon align-self-center"><i class="fas fa-check"></i></span>
                                   <span class="media-body pl-3">Orçamentos</span>
                               </div>
                           </li>
                           <li class="py-1">
                               <!-- List Box -->
                               <div class="list-box media">
                                   <span class="icon align-self-center"><i class="fas fa-check"></i></span>
                                   <span class="media-body pl-3">Envio de Documetos</span>
                               </div>
                           </li>
                           <li class="py-1">
                               <!-- List Box -->
                               <div class="list-box media">
                                   <span class="icon align-self-center"><i class="fas fa-check"></i></span>
                                   <span class="media-body pl-3">Dicas de cuidados</span>
                               </div>
                           </li>
                       </ul>
                       <div class="icon-box d-flex mt-3">
                           <div class="service-icon">
                               <span><i class="fas fa-bell"></i></span>
                           </div>
                           <div class="service-icon px-3">
                               <span><i class="fas fa-envelope-open"></i></span>
                           </div>
                           <div class="service-icon">
                               <span><i class="fas fa-video"></i></span>
                           </div>
                       </div>
                   </div>
               </div>
           </div>
       </div>
   </section>
   <!-- ***** Discover Area End ***** -->

   <!-- ***** Testimonial Area Start ***** -->
   <section class="section testimonial-area ptb_100">
       <div class="container text-center">
           <div class="row justify-content-center align-items-center">
               <div class="col-12 col-md-10 col-lg-8">
                   <div class="testimonials owl-carousel">
                       <div class="single-testimonial p-3 p-md-5">
                           <img src="{{ url('site') }}/assets/img/beto.jpg" class="mx-auto d-block" alt="">
                           <h4 class="client-name mt-4 mb-2">Roberto de Jesus</h4>
                           <h6 class="client-address fw-4">Analista de Sistemas</h6>
                           <div class="client-rating mt-2 mb-3">
                               <i class="fas fa-star"></i>
                               <i class="fas fa-star"></i>
                               <i class="fas fa-star"></i>
                               <i class="fas fa-star"></i>
                               <i class="fas fa-star"></i>
                           </div>
                           <!-- Client Description -->
                           <div class="client-description">
                               <!-- Client Text -->
                               <div class="client-text">
                                   <p>Após muitos anos sem atividade física fui iniciar as atividades e acabei
                                       sofrendo uma lesão na panturilha, pensei que iria ficar mancando por
                                       semanas, mas graças a Drª Ingrid Brito, minha lesão durou apenas 5 dias,
                                       foram necessário 5 sessões de ultrassom e eu já estava novinho de novo.
                                       Obrigado Drª!!!</p>
                               </div>
                           </div>
                       </div>
                   </div>
               </div>
           </div>
       </div>
   </section>
   <!-- ***** Testimonial Area End ***** -->

   <!-- ***** Price Plan Area Start ***** -->
   <section id="pricing" class="section price-plan-area bg-gray overflow-hidden ptb_100">
       <div class="container">
           <div class="row justify-content-center">
               <div class="col-12 col-md-10 col-lg-8">
                   <!-- Section Heading -->
                   <div class="section-heading text-center">
                       <h2>Dúvidas Frequêntes</h2>
                   </div>
               </div>
           </div>
           <div class="row">
               <div class="col-12">
                   <!-- FAQ Content -->
                   <div class="faq-content">
                       <div class="accordion pt-5" id="apolo-accordion">
                           <div class="row">
                               <div class="col-12 col-lg-6">
                                   <!-- Single Accordion Item -->
                                   <div class="card my-2">
                                       <!-- Card Header -->
                                       <div class="card-header bg-white">
                                           <h2 class="mb-0">
                                               <button class="btn p-2" type="button"
                                                   data-toggle="collapse" data-target="#collapseOne">
                                                   Quais tipo de atendimentos a {{ env('APP_EMPRESA') }}
                                                   oferece?
                                               </button>
                                           </h2>
                                       </div>
                                       <div id="collapseOne" class="collapse show"
                                           data-parent="#apolo-accordion">
                                           <!-- Card Body -->
                                           <div class="card-body">
                                               @foreach ($servicos as $servico)
                                                   {{ $servico->titulo }},
                                               @endforeach
                                               Atendimento Dominiliar
                                           </div>
                                       </div>
                                   </div>
                                   <!-- Single Accordion Item -->
                                   <div class="card my-2">
                                       <!-- Card Header -->
                                       <div class="card-header bg-white">
                                           <h2 class="mb-0">
                                               <button class="btn collapsed p-2" type="button"
                                                   data-toggle="collapse" data-target="#collapseTwo">
                                                   Como funciona?
                                               </button>
                                           </h2>
                                       </div>
                                       <div id="collapseTwo" class="collapse"
                                           data-parent="#apolo-accordion">
                                           <!-- Card Body -->
                                           <div class="card-body">
                                               A Drª Ingrid Brito irá realizar uma avaliação e lhe inidcará o
                                               tratamento adequado.
                                           </div>
                                       </div>
                                   </div>
                                   <!-- Single Accordion Item -->
                                   <div class="card my-2">
                                       <!-- Card Header -->
                                       <div class="card-header bg-white">
                                           <h2 class="mb-0">
                                               <button class="btn collapsed p-2" type="button"
                                                   data-toggle="collapse" data-target="#collapseThree">
                                                   Quando começamos meu tratamento?
                                               </button>
                                           </h2>
                                       </div>
                                       <div id="collapseThree" class="collapse"
                                           data-parent="#apolo-accordion">
                                           <!-- Card Body -->
                                           <div class="card-body">
                                               Após a avaliação será emitido o contrato de prestação de serviço,
                                               após a assinatura do contrato, tudo ok!
                                           </div>
                                       </div>
                                   </div>
                               </div>
                               <div class="col-12 col-lg-6">
                                   <!-- Single Accordion Item -->
                                   <div class="card my-2">
                                       <!-- Card Header -->
                                       <div class="card-header bg-white">
                                           <h2 class="mb-0">
                                               <button class="btn collapsed p-2" type="button"
                                                   data-toggle="collapse" data-target="#collapseFour">
                                                   Como será realizada as sessões?
                                               </button>
                                           </h2>
                                       </div>
                                       <div id="collapseFour" class="collapse"
                                           data-parent="#apolo-accordion">
                                           <!-- Card Body -->
                                           <div class="card-body">
                                               Nosso sistema de atendimento estará realizando seu agendamento
                                               nas datas disponíveis, mas fique tranquilo a agenda é bastante
                                               fexivel.
                                           </div>
                                       </div>
                                   </div>
                                   <!-- Single Accordion Item -->
                                   <div class="card my-2">
                                       <!-- Card Header -->
                                       <div class="card-header bg-white">
                                           <h2 class="mb-0">
                                               <button class="btn p-2" type="button"
                                                   data-toggle="collapse" data-target="#collapseFive">
                                                   Qual o tempo de cada sessão?
                                               </button>
                                           </h2>
                                       </div>
                                       <div id="collapseFive" class="collapse"
                                           data-parent="#apolo-accordion">
                                           <!-- Card Body -->
                                           <div class="card-body">
                                               As sessões duram em média de 45 minutos a 1 hora.
                                           </div>
                                       </div>
                                   </div>
                                   <!-- Single Accordion Item -->
                                   <div class="card my-2">
                                       <!-- Card Header -->
                                       <div class="card-header bg-white">
                                           <h2 class="mb-0">
                                               <button class="btn collapsed p-2" type="button"
                                                   data-toggle="collapse" data-target="#collapseSix">
                                                   Por qual tipo de Profissional estarei sendo atendido?
                                               </button>
                                           </h2>
                                       </div>
                                       <div id="collapseSix" class="collapse"
                                           data-parent="#apolo-accordion">
                                           <!-- Card Body -->
                                           <div class="card-body">
                                               Profissionais qualificados e registrados.
                                           </div>
                                       </div>
                                   </div>
                               </div>
                           </div>
                       </div>
                   </div>
               </div>
           </div>
       </div>
   </section>
   <!-- ***** Price Plan Area End ***** -->

   <!-- ***** Team Area Start ***** -->
   {{-- <section class="section team-area team-style-two overflow-hidden ptb_100">
       <div class="container">
           <div class="row justify-content-center">
               <div class="col-12 col-md-10 col-lg-8">
                   <!-- Section Heading -->
                   <div class="section-heading text-center">
                       <h2 class="text-capitalize">Nosso Time</h2>
                   </div>
               </div>
           </div>
           <div class="row">
               <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                   <div class="single-team text-center overflow-hidden m-2 m-lg-0">
                       <div class="team-thumb d-inline-block position-relative overflow-hidden">
                           <img src="{{ url('site') }}/assets/img/avatar/ingrid.png" alt="">
                           <div class="team-overlay">
                               <h4 class="team-name text-white">Drª Ingrid Brito</h4>
                               <h6 class="team-post text-white mt-2 mb-3">Fisioterapeuta</h6>
                           </div>
                       </div>
                   </div>
               </div>
               <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                   <div class="single-team text-center overflow-hidden m-2 m-lg-0">
                       <div class="team-thumb d-inline-block position-relative overflow-hidden">
                           <img src="{{ url('site') }}/assets/img/avatar/vitoria.jpg" alt="">
                           <div class="team-overlay">
                               <h4 class="team-name text-white">Vitória Nascimento</h4>
                               <h6 class="team-post text-white mt-2 mb-3">Estéticista</h6>
                           </div>
                       </div>
                   </div>
               </div>
           </div>
       </div>
   </section> --}}

   <!--====== Contact Area Start ======-->
   <section id="contact" class="contact-area bg-gray ptb_100">
       <div class="container">
           <div class="row justify-content-center">
               <div class="col-12 col-md-10 col-lg-8">
                   <!-- Section Heading -->
                   <div class="section-heading text-center">
                       <h2 class="text-capitalize">Fale Conosco</h2>
                   </div>
               </div>
           </div>
           <div class="row justify-content-between">
               <div class="col-12 col-md-5">
                   <!-- Contact Us -->
                   <div class="contact-us">
                       <ul>
                           <li class="py-2">
                               <a class="media" href="{{ url('site') }}/#">
                                   <div class="social-icon mr-3">
                                       <i class="fas fa-home"></i>
                                   </div>
                                   <span class="media-body align-self-center">{{ env('ENDERECO') }}</span>
                               </a>
                           </li>
                           <li class="py-2">
                               <a class="media" href="{{ url('site') }}/#">
                                   <div class="social-icon mr-3">
                                       <i class="fab fa-whatsapp"></i>
                                   </div>
                                   <span class="media-body align-self-center">{{ env('CELULAR') }}</span>
                               </a>
                           </li>
                           <li class="py-2">
                               <a class="media" href="{{ url('site') }}/#">
                                   <div class="social-icon mr-3">
                                       <i class="fas fa-phone-alt"></i>
                                   </div>
                                   <span class="media-body align-self-center">{{ env('CELULAR') }}</span>
                               </a>
                           </li>
                           <li class="py-2">
                               <a class="media" href="{{ url('site') }}/#">
                                   <div class="social-icon mr-3">
                                       <i class="fas fa-envelope"></i>
                                   </div>
                                   <span class="media-body align-self-center">{{ env('EMAIL') }}</span>
                               </a>
                           </li>
                       </ul>
                   </div>
               </div>
               <div class="col-12 col-md-6 pt-4 pt-md-0">
                   <!-- Contact Box -->
                   <div class="contact-box text-center">
                       <!-- Contact Form -->
                       <form id="contact-form" method="POST" action="{{route('contato.store')}}">
                            @csrf
                           <div class="row">
                               <div class="col-12">
                                   <div class="form-group">
                                       <input type="text" class="form-control" name="nome" id="nome2" placeholder="Nome"
                                           required="required">
                                   </div>
                                   <div class="form-group">
                                       <input type="email" class="form-control" name="email" id="email"
                                           placeholder="Email" required="required">
                                   </div>
                                   <div class="form-group">
                                       <input type="text" class="form-control" name="celular" id="celular"
                                           placeholder="Celular" required="required">
                                   </div>
                                   <div class="form-group">
                                       <input type="text" class="form-control" name="assunto" id="assunto"
                                           placeholder="Assunto" required="required">
                                   </div>
                               </div>
                               <div class="col-12">
                                   <div class="form-group">
                                       <textarea class="form-control" name="msg" id="msg" placeholder="Mensagem"
                                           required="required"></textarea>
                                   </div>
                               </div>
                               <div class="col-12">
                                   <button type="button" id="sendContact" class="btn btn-lg btn-block mt-3"><span class="text-white pr-3"><i class="fas fa-paper-plane"></i></span>Enviar</button>
                                   <button id="carregando" class="btn btn-lg btn-primary w-100 mb-5" disabled>
                                    <span class="spinner-border spinner-border-sm align-middle ms-2"></span> Processando...
                                 </button>
                               </div>
                           </div>
                       </form>
                       <p class="form-message"></p>
                   </div>
               </div>
           </div>
       </div>
   </section>
@endsection
