<!doctype html>
<html class="no-js" lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="description" content="">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="@yield('description')" />
    <meta name="keywords" content="@yield('keywords')" />
    <meta name="author" content="{{ env('APP_COPYRIGHT') }}" />
    <title>@yield('titulo') {{ env('APP_NAME') }}</title>

    <link rel="icon" href="{{ url('site') }}/assets/img/favicon.png">

    <!-- ***** All CSS Files ***** -->

    <!-- Style css -->
    <link rel="stylesheet" href="{{ url('site') }}/assets/css/style.css">

</head>

<body class="homepage-5">

    <style>
        .sempreDireita{
            position: fixed;
            z-index: 560;
            bottom: 20px;
            height: 61px;
            width: 240px;
            left: 0;
        }
    </style>
    <div class="sempreDireita">
        <a href="https://api.whatsapp.com/send?1=pt_BR&phone=55{{tiraMoeda(env('CELULAR'))}}&text=Olá estou no site da {{env('APP_EMPRESA')}} e gostaria de atendimento">
            <img src="{{url('site/assets/img/whatsapp-messenger-lopak.png')}}">
        </a>
    </div>

    <!--====== Scroll To Top Area Start ======-->
    <div id="scrollUp" title="Scroll To Top">
        <i class="fas fa-arrow-up"></i>
    </div>
    <!--====== Scroll To Top Area End ======-->

    <div class="main">
        <!-- ***** Header Start ***** -->
        <header class="navbar navbar-sticky navbar-expand-lg navbar-dark">
            <div class="container position-relative">
                <a class="navbar-brand" href="{{ route('site.home') }}">
                    <img class="navbar-brand-regular" src="{{ url('site') }}/assets/img/logo/logo-white.png"
                        alt="brand-logo">
                    <img class="navbar-brand-sticky" src="{{ url('site') }}/assets/img/logo/logo.png"
                        alt="sticky brand-logo">
                </a>
                <button class="navbar-toggler d-lg-none" type="button" data-toggle="navbarToggler"
                    aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="navbar-inner">
                    <!--  Mobile Menu Toggler -->
                    <button class="navbar-toggler d-lg-none" type="button" data-toggle="navbarToggler"
                        aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <nav>
                        <ul class="navbar-nav" id="navbar-nav">
                            <li class="nav-item"> <a class="nav-link" href="{{ route('site.home') }}">Home</a></li>
                            <li class="nav-item"> <a class="nav-link" href="{{ route('site.home') }}#sobre">Sobre  A Home Physio</a></li>
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="javascript:;" id="navbarDropdownMenuLink"
                                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Atendimentos
                                </a>
                                <ul class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                                    @foreach ($servicos as $servico)
                                        <li><a class="dropdown-item" href="{{route('site.servico',$servico->url)}}">{{ $servico->titulo }}</a></li>
                                    @endforeach
                                </ul>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="{{route('site.home')}}#contact">Contato</a>
                            </li>
                        </ul>
                    </nav>
                </div>
            </div>
        </header>

        @yield('content')

         <!--====== Height Emulator Area Start ======-->
         <div class="height-emulator d-none d-lg-block"></div>
         <!--====== Height Emulator Area End ======-->

         <!--====== Footer Area Start ======-->
         <footer class="footer-area footer-fixed">
             <!-- Footer Top -->
             <div class="footer-top ptb_100">
                 <div class="container">
                     <div class="row">
                         <div class="col-12 col-sm-6 col-lg-3">
                             <!-- Footer Items -->
                             <div class="footer-items">
                                 <!-- Logo -->
                                 <a class="navbar-brand" href="{{ url('site') }}/#">
                                     <img class="logo" src="{{ url('site') }}/assets/img/logo/logo.png"
                                         alt="">
                                 </a>
                                 <p class="mt-2 mb-3">
                                     A {{ env('APP_EMPRESA') }} tem como objetivo de prestar serviços de qualidade
                                     aos seus pacientes, com profissionais capacitados, tecnologia e equipe
                                     multiprofissional - integração das áreas para o melhor tratamento.
                                 </p>
                                 <!-- Social Icons -->
                                 <div class="social-icons d-flex">
                                     <a class="google-plus" href="{{ url('site') }}/#">
                                         <i class="fab fa-instagram"></i>
                                         <i class="fab fa-instagram"></i>
                                     </a>
                                     <a class="vine" href="https://api.whatsapp.com/send?1=pt_BR&phone=55{{tiraMoeda(env('CELULAR'))}}&text=Olá estou no site da {{env('APP_EMPRESA')}} e gostaria de atendimento" target="_blank">
                                         <i class="fab fa-whatsapp"></i>
                                         <i class="fab fa-whatsapp"></i>
                                     </a>
                                 </div>
                             </div>
                         </div>
                         <div class="col-12 col-sm-6 col-lg-3">
                             <!-- Footer Items -->
                             <div class="footer-items">
                                 <!-- Footer Title -->
                                 <h3 class="footer-title mb-2">Menu</h3>
                                 <ul>
                                     <li class="py-2"><a href="{{ url('site') }}/#">Home</a></li>
                                     <li class="py-2"><a href="{{ route('site.home') }}#sobre">Sobre a {{ env('APP_EMPRESA') }}</a></li>
                                </ul>
                             </div>
                         </div>
                         <div class="col-12 col-sm-6 col-lg-3">
                             <!-- Footer Items -->
                             <div class="footer-items">
                                 <!-- Footer Title -->
                                 <h3 class="footer-title mb-2">Atendimentos</h3>
                                 <ul>
                                     @foreach ($servicos as $servico)
                                         <li class="py-2"><a href="{{route('site.servico',$servico->url)}}">{{ $servico->titulo }}</a></li>
                                     @endforeach
                                 </ul>
                             </div>
                         </div>
                         <div class="col-12 col-sm-6 col-lg-3">
                             <!-- Footer Items -->
                             <div class="footer-items">
                                 <!-- Footer Title -->
                                 <h3 class="footer-title mb-2">Download</h3>
                                 <!-- Store Buttons -->
                                 <div class="button-group store-buttons store-black d-flex flex-wrap">
                                     <a href="{{ url('site') }}/#">
                                         <img src="{{ url('site') }}/assets/img/icon/google-play-black.png" alt="">
                                     </a>
                                     <a href="{{ url('site') }}/#">
                                         <img src="{{ url('site') }}/assets/img/icon/app-store-black.png" alt="">
                                     </a>
                                 </div>
                             </div>
                         </div>
                     </div>
                 </div>
             </div>
             <!-- Footer Bottom -->
             <div class="footer-bottom">
                 <div class="container">
                     <div class="row">
                         <div class="col-12">
                             <!-- Copyright Area -->
                             <div
                                 class="copyright-area d-flex flex-wrap justify-content-center justify-content-sm-between text-center py-4">
                                 <!-- Copyright Left -->
                                 <div class="copyright-left">&copy; Copyrights {{date('Y')}}  {{ env('APP_EMPRESA') }}. Todos os direitos reservados.</div>
                                 <!-- Copyright Right -->
                                 <div class="copyright-right">Fisioterapia por <i class="fas fa-heart"></i> <a href="{{env('SITELOPAK')}}"><img src="{{env('LOGOLOPAK')}}"></a></div>
                             </div>
                         </div>
                     </div>
                 </div>
             </div>
         </footer>
         <!--====== Footer Area End ======-->
     </div>


     <!-- ***** All jQuery Plugins ***** -->

     <!-- jQuery(necessary for all JavaScript plugins) -->
     <script src="{{ url('site') }}/assets/js/jquery/jquery.min.js"></script>

     <!-- Bootstrap js -->
     <script src="{{ url('site') }}/assets/js/bootstrap/popper.min.js"></script>
     <script src="{{ url('site') }}/assets/js/bootstrap/bootstrap.min.js"></script>

     <!-- Plugins js -->
     <script src="{{ url('site') }}/assets/js/plugins/plugins.min.js"></script>

     <!-- Active js -->
     <script src="{{ url('site') }}/assets/js/active.js"></script>

     <script>
          $(document).ready(function() {
              $("#carregando").hide();
              $("#sendContact").on("click",function(){
                $("#sendContact").hide();
                $("#carregando").show();
                if($("#nome2").val() == '' || $("#email").val() == '' || $("#celular").val() == '' || $("#assunto").val() == '' || $("#msg").val() == ''){
                    alert('Prencha todos os campos para continuar');
                    $("#sendContact").show();
                    $("#carregando").hide();
                }else{
                    document.getElementById("contact-form").submit();
                }
              });
              $("#iniciar").on("click",function(){
                  if($("#nome").val() == ''){
                   alert('Informe seu nome para continuar')
               }else{
                      if($("#descricao").val() == ''){
                      alert('Descreva um pouco sobre sua necessidade')
                  }else{
                      window.location.href = 'https://api.whatsapp.com/send?1=pt_BR&phone=5571992364153&text=Olá eu me chamo '+$("#nome").val()+' e preciso de atendimento pois '+$("#descricao").val();
                  }
               }
              });
          });
      </script>
 </body>
 </html>
