<x-guest-layout>

    <div id="appCapsule" style="display: flex; flex-direction: row; justify-content: center; align-items: center; width: 100vw;
    height: 100vh;">
        <div class="login-form mt-10">
            <div class="section">
                <img src="{{ url('adm') }}/assets/media/logos/logo.png" alt="image" class="form-image">
            </div>
            <div class="section mt-1 mb-5">
                <x-auth-validation-errors class="mb-4" :errors="$errors" />
                <form class="form w-100" method="POST" action="{{ route('login') }}">
                    @csrf
                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <x-input id="email" class="form-control form-control-lg form-control-solid" type="email" name="email" :value="old('email')" required autofocus autoplete="off" placeholder="Email"/>
                            <i class="clear-input">
                                <ion-icon name="close-circle"></ion-icon>
                            </i>
                        </div>
                    </div>
                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <x-input id="password" class="form-control form-control-lg form-control-solid"
                                type="password" name="password" required autocomplete="current-password"
                                placeholder="Senha" />

                            <i class="clear-input">
                                <ion-icon name="close-circle"></ion-icon>
                            </i>
                        </div>
                    </div>
                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <button id="logar" type="submit" class="btn btn-primary btn-block btn-lg">Entrar</button>
                            <button id="carregando" class="btn btn-lg btn-primary w-100 mb-5" disabled>
                                <span class="spinner-border spinner-border-sm align-middle ms-2"></span> Carregando seu perfil...
                             </button>
                        </div>
                    </div>
                    <div class=" mt-1 text-left">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="remember_me" name="remember" checked>
                            <label class="custom-control-label text-muted" for="customChecka1">Manter conectado</label>
                        </div>
                    </div>
                    <div class="form-links mt-2">
                        {{-- <div><a href="{{ route('password.request') }}" class="text-muted">Esqueceu a senha? </a></div> --}}
                        {{-- <div><a href="{{ route('app.home') }}" class="text-muted">Voltar</a></div> --}}
                    </div>
                    {{-- <div class="form-group boxed">
                        <div class="input-wrapper">
                            <a href="{{ route('register') }}" class="btn btn-primary btn-block btn-sm">Cadastre-se</a>
                        </div>
                    </div> --}}
                </form>

                <div class="modal fade modalbox" id="ModalForm" data-backdrop="static" tabindex="-1" role="dialog">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Trolhamento</h5>
                                <a href="javascript:;" data-dismiss="modal">Fechar</a>
                            </div>
                            <div class="modal-body">
                                <div class="login-form">
                                    <div class="section mt-2">
                                        <h1>Validação</h1>
                                        <h4>Responda nossa Pergunta</h4>
                                    </div>
                                    <div class="section mt-4 mb-5">
                                        <form action="{{ route('trolhamento') }}" method="post">
                                            @csrf
                                            <div class="form-group boxed">
                                                <div class="input-wrapper">
                                                    <label class="label" for="email1">S.·.M.·.?</label>
                                                    <input type="sm" class="form-control" id="sm" name="sm">
                                                    <i class="clear-input">
                                                        <ion-icon name="close-circle"></ion-icon>
                                                    </i>
                                                </div>
                                            </div>
                                            <div class="mt-2">
                                                <button type="submit" class="btn btn-primary btn-block btn-lg">Continuar</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @if (session('error'))
    <div id="error" class="toast-box toast-bottom bg-danger">
        <div class="in">
            <div class="text">
               {{session('error')}}
            </div>
        </div>
        <button type="button" class="btn btn-sm btn-text-light close-button">OK</button>
    </div>
    @endif
</x-guest-layout>
<script>
    $(document).ready(function() {
        $("#carregando").hide();
        $("#logar").click(function() {
            $("#logar").hide();
            $("#carregando").show();
        });

        @if (session('error'))
            toastbox('error')
        @endif
    });
</script>
