@extends('app.base')
@section('content')
    <!-- App Header -->
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" onclick="history.back()" class="headerButton">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">{{ utf8_decode($loja->loja) }} - {{ $loja->numero }}</div>
        <div class="right" id="favorito">

        </div>
    </div>


    <!-- App Capsule -->
    <div id="appCapsule">
        <div class="section full">
            <div class="wide-block pt-2 pb-2 product-detail-header">
                <h1 class="title">{{ utf8_decode($loja->loja) }} - {{ $loja->numero }}</h1>
                <h4>Vem.·. M.·. {{ utf8_decode($loja->vm) }}</h4>
                <h4>1ºVig.·. {{ utf8_decode($loja->vigilante1) }}</h4>
                <h4>2ºVig.·. {{ utf8_decode($loja->vigilante2) }}</h4>
            </div>
        </div>

        <div class="section full mt-2">
            <div class="section-title">Informações e Contatos</div>
            <div class="wide-block pt-2 pb-2">
                <div class="row">
                    <div class="col-12">
                        @foreach ($loja->telefones as $telefone)
                            <a href="{{ $telefone->tipo == 'Whatsapp'? 'https://api.whatsapp.com/send?1=pt_BR&phone=+55' .tiraMoeda($telefone->numero) .'&text= Olá vi seu anúncio no aplicativo da ' .env('APP_NAME'): 'tel:' . tiraMoeda($telefone->numero) }}">
                                <div class="accordion-header">
                                    <ion-icon name="{{ $ico[$telefone->tipo] }}"></ion-icon>
                                    {{ $telefone->numero }}
                                </div>
                            </a>
                        @endforeach
                    </div>
                    <div class="col-12">
                        <a href="mailto:{{$loja->email}}" target="_system">
                            <div class="accordion-header">
                                <ion-icon name="mail-outline"></ion-icon>
                                {{$loja->email}}
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="section full mt-2" style="margin-bottom: 100px;">
            <div class="section-title">Localização</div>
            <div class="wide-block pt-2 pb-2">
                <div class="row">
                    <div class="col-12">
                        <div class="accordion-header">
                            <ion-icon name="location-outline"></ion-icon>
                            Endereço: {{utf8_decode($loja->endereco)}}, {{$loja->numeroend}} {{utf8_decode($loja->complemento)}} {{utf8_decode($loja->bairro)}} {{utf8_decode($loja->cidade)}} {{utf8_decode($loja->estado)}}-{{$loja->cep}}
                            <button type="button" class="btn btn-primary btn-sm btn-block" data-toggle="modal" data-target="#ComoChegar">COMO CHEGAR?</button>
                        </div>
                        <!-- Share Action Sheet -->
                        <div class="modal fade action-sheet inset" id="ComoChegar" tabindex="-1" role="dialog">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Abrir Localização</h5>
                                    </div>
                                    <div class="modal-body">
                                        <div class="action-sheet-content text-center">
                                            <div class="row">
                                                <div class="col-6">
                                                    <a href="javascript:return false;"
                                                        onclick="javascript:window.open('https://www.google.com/maps?q={{utf8_decode($loja->endereco)}}+{{$loja->numeroend}}+{{utf8_decode($loja->complemento)}}+{{utf8_decode($loja->bairro)}}+{{utf8_decode($loja->cidade)}}+{{utf8_decode($loja->estado)}}+{{$loja->cep}}', '_system');"
                                                        class="btn btn-icon">
                                                        <img src="{{url('app/assets/img/mapa.png')}}" width="35" />
                                                    </a>
                                                </div>
                                                <div class="col-6">
                                                    <a href="javascript:return false;"
                                                        onclick="javascript:window.open('https://www.waze.com/ul?q={{utf8_decode($loja->endereco)}}+{{$loja->numeroend}}+{{utf8_decode($loja->complemento)}}+{{utf8_decode($loja->bairro)}}+{{utf8_decode($loja->cidade)}}+{{utf8_decode($loja->estado)}}+{{$loja->cep}}', '_system');"
                                                        class="btn btn-icon">
                                                        <img src="{{url('app/assets/img/waze.png')}}" width="35" />
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- * Share Action Sheet -->
                    </div>
                </div>
            </div>
        </div>
        <div class="fab-button text bottom-center">
            <a href="#" class="fab" data-toggle="modal" data-target="#Ligar">
                <ion-icon name="call-outline"></ion-icon>
                Ligar
            </a>
        </div>
        <!-- Iconed Action Sheet -->
        <div class="modal fade action-sheet" id="Ligar" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Números Disponíveis</h5>
                    </div>
                    <div class="modal-body">
                        <ul class="action-button-list">
                            @foreach ($loja->telefones as $telefone)
                            <li>
                                <a href="{{ $telefone->tipo == 'Whatsapp'? 'https://api.whatsapp.com/send?1=pt_BR&phone=+55' .tiraMoeda($telefone->numero) .'&text= Olá vi seu anúncio no aplicativo da ' .env('APP_NAME'): 'tel:' . tiraMoeda($telefone->numero) }}"
                                    class="btn btn-list text-primary">
                                    <span>
                                        <ion-icon name="{{ $ico[$telefone->tipo] }}"></ion-icon>
                                        {{ $telefone->numero }}
                                    </span>
                                </a>
                            </li>
                            @endforeach
                            <!--href="javascript:return false;" onclick="javascript:window.open('tel:38984132243', '_system');"-->
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- * App Capsule -->
@endsection
@section('js')
    <script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>


    <script>
        Inputmask({
            "mask": "(99) 99999-9999"
        }).mask("#contato");
        Inputmask({
            "mask": "999.999.999-99"
        }).mask("#cpf");
        Inputmask({
            "mask": "99/99"
        }).mask("#aniv");
        Inputmask({
            "mask": "(99) 99999-9999"
        }).mask("#celular");
        Inputmask({
            "mask": "(99) 9999-9999"
        }).mask("#telefone");
        Inputmask({
            "mask": "99999-999"
        }).mask("#cep");
    </script>

    <script>
        function AddFavorito(id){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('app.add.favorito') }}",
                method: 'POST',
                data: {
                    id: id,
                },
                success: function(result) {
                    $("#favorito").html(result);
                }
            });
        }
        function DellFavorito(id){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('app.dell.favorito') }}",
                method: 'POST',
                data: {
                    id: id,
                },
                success: function(result) {
                    $("#favorito").html(result);
                }
            });
        }
    </script>
@endsection
