@extends('app.base')
@section('content')
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" class="headerButton" data-toggle="modal" data-target="#sidebarPanel">
                <ion-icon name="menu-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            <img src="{{ url('app/assets/img/logo.png') }}" width="200">
        </div>
        <div class="right">
            <a href="{{ route('app.filtros') }}" class="headerButton">
                <ion-icon name="search-outline"></ion-icon>
            </a>
        </div>
    </div>

    <!-- App Capsule -->
    <div id="appCapsule">
        <div class="listview-title mt-2">Busca rápida</div>
        <div id="result">
            <form action="{{route('filtrar')}}" method="post">
                @csrf
                <ul class="listview image-listview">
                    <li>
                        <a href="#" data-toggle="modal" data-target="#lista_estados" class="item">
                            <img src="{{ url('app') }}/assets/img/potencias.png" alt="image" class="image">
                            <div class="in">
                                <div>Selecione um Estado</div>
                                <span class="badge badge-primary"></span>
                            </div>
                        </a>
                    </li>
                </ul>
                <div class="section full mt-2 ml-2 mr-2">
                    <button id="buscar" type="submit" class="btn btn-primary btn-block">BUSCAR</button>
                </div>
            </form>


            <div class="modal fade modalbox" id="lista_estados" data-backdrop="static" tabindex="-1" role="dialog">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Estados</h5>
                            <a href="javascript:;" data-dismiss="modal">Fechar</a>
                        </div>
                        <div class="modal-body p-0">
                            <ul class="listview image-listview flush mb-2">
                                @foreach ($estados as $result)
                                <li onclick="javascript:setEstado({{$result->setEstado->id}})">
                                    <div class="item">
                                        <img src="{{url('app')}}/assets/img/estados/{{$result->setEstado->thumb}}" alt="image" class="image">
                                        <div class="in">
                                            <div>{{$result->setEstado->nome}}</div>
                                        </div>
                                    </div>
                                </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- * App Capsule -->
@endsection

@section('js')
    <script>

        $(document).ready(function() {
            $("#buscar").on("click",function() {
                $("#loader").show();
            });
        });

        function setEstado(id){
            $("#lista_estados").modal('hide');
            $("#loader").show();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('get.cidades') }}",
                method: 'POST',
                data: {
                    estado: id,
                },
                success: function(result) {
                    $("#loader").hide();
                    $("#result").html(result);
                }
            });
        }

        function Cidade(id){
            $("#lista_cidades").modal('hide');
            $("#loader").show();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{route('filtro.categorias')}}",
                method: 'POST',
                data: {
                    id: id,
                },
                success: function(result) {
                    $("#loader").hide();
                    $("#result").html(result);
                }
            });
        }

        function Categoria(id){
            $("#lista_categorias").modal('hide');
            $("#loader").show();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{route('filtro.sub.cat')}}",
                method: 'POST',
                data: {
                    id: id,
                    estado: $("#estado").val(),
                    cidade: $("#cidade").val(),
                },
                success: function(result) {
                    $("#loader").hide();
                    $("#result").html(result);
                }
            });
        }

        function Sub(id){
            $("#lista_subs").modal('hide');
            $("#loader").show();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{route('filtro.full')}}",
                method: 'POST',
                data: {
                    id: id,
                    categoria: $("#categoria").val(),
                    estado: $("#estado").val(),
                    cidade: $("#cidade").val(),
                },
                success: function(result) {
                    $("#loader").hide();
                    $("#result").html(result);
                }
            });
        }



    </script>
@endsection
