@extends('app.base')
@section('content')
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" onclick="history.back()" class="headerButton">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
           EVENTO
        </div>
        <div class="right">

        </div>
    </div>


    <div id="appCapsule">
        <div class="blog-post">
            <div class="mb-2">
                <img src="{{ url("storage/{$evento->image}") }}" alt="image" class="imaged square w-100">
            </div>
            <h3 class="title">{{ $evento->titulo }}</h3>

            <div class="post-header">
                <div>
                    <a href="#">
                        <img src="{{ url('storage/self/post-user.jpg') }}" alt="avatar" class="imaged w24 rounded mr-05">
                        {{ env('APP_NAME') }}
                    </a>
                </div>
                {{ date('d/m/Y H:i', strtotime($evento->created_at)) }}
            </div>
            <div class="post-body">
                <p>{!! $evento->descricao !!}</p>
            </div>
        </div>


        {{-- <div class="section mt-4">
            <button type="button" class="btn btn-outline-primary btn-block" data-toggle="modal"
                data-target="#actionSheetShare">
                <ion-icon name="share-outline"></ion-icon>
               Compartilhar
            </button>
        </div> --}}

        {{-- <div class="divider mt-4 mb-3"></div>

        <div class="section">
            <div class="section-title mb-1">
                <h3 class="mb-0">Comments (3)</h3>
            </div>
            <div class="pt-2 pb-2">
                <!-- comment block -->
                <div class="comment-block">
                    <!--item -->
                    <div class="item">
                        <div class="avatar">
                            <img src="assets/img/sample/avatar/avatar1.jpg" alt="avatar" class="imaged w32 rounded">
                        </div>
                        <div class="in">
                            <div class="comment-header">
                                <h4 class="title">Diego Morata</h4>
                                <span class="time">just now</span>
                            </div>
                            <div class="text">
                                Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                            </div>
                            <div class="comment-footer">
                                <a href="javascript:;" class="comment-button">
                                    <ion-icon name="heart-outline"></ion-icon>
                                    Like (523)
                                </a>
                                <a href="javascript:;" class="comment-button">
                                    <ion-icon name="chatbubble-outline"></ion-icon>
                                    Reply
                                </a>
                            </div>
                        </div>
                    </div>
                    <!-- * item -->
                    <!--item -->
                    <div class="item">
                        <div class="avatar">
                            <img src="assets/img/sample/avatar/avatar3.jpg" alt="avatar" class="imaged w32 rounded">
                        </div>
                        <div class="in">
                            <div class="comment-header">
                                <h4 class="title">Henry Itondo</h4>
                                <span class="time">05:50 PM</span>
                            </div>
                            <div class="text">
                                Sed laoreet leo eget maximus ultricies.
                            </div>
                            <div class="comment-footer">
                                <a href="javascript:;" class="comment-button">
                                    <ion-icon name="heart" class="text-danger"></ion-icon>
                                    Like (4)
                                </a>
                                <a href="javascript:;" class="comment-button">
                                    <ion-icon name="chatbubble-outline"></ion-icon>
                                    Reply
                                </a>
                            </div>
                        </div>
                    </div>
                    <!-- * item -->
                    <!--item -->
                    <div class="item">
                        <div class="avatar">
                            <img src="assets/img/sample/avatar/avatar4.jpg" alt="avatar" class="imaged w32 rounded">
                        </div>
                        <div class="in">
                            <div class="comment-header">
                                <h4 class="title">Carmelita Marsham</h4>
                                <span class="time">Sep 23, 2020</span>
                            </div>
                            <div class="text">
                                Vivamus lobortis, orci et commodo pulvinar, eros nibh volutpat ipsum, in rhoncus risus
                                dolor.
                            </div>
                            <div class="comment-footer">
                                <a href="javascript:;" class="comment-button">
                                    <ion-icon name="heart-outline"></ion-icon>
                                    Like (5)
                                </a>
                                <a href="javascript:;" class="comment-button">
                                    <ion-icon name="chatbubble-outline"></ion-icon>
                                    Reply
                                </a>
                            </div>
                        </div>
                    </div>
                    <!-- * item -->
                </div>
                <!-- * comment block -->
            </div>
        </div>

        <div class="divider mt-2 mb-3"></div>

        <div class="section mt-2">
            <h3 class="mb-0">Send a Comment</h3>
            <div class="pt-2 pb-2">
                <form>
                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <input type="text" class="form-control" id="name5" placeholder="Name">
                            <i class="clear-input">
                                <ion-icon name="close-circle"></ion-icon>
                            </i>
                        </div>
                    </div>

                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <input type="email" class="form-control" id="email5" placeholder="Email">
                            <i class="clear-input">
                                <ion-icon name="close-circle"></ion-icon>
                            </i>
                        </div>
                    </div>

                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <textarea id="comment" rows="4" class="form-control" placeholder="Comment"></textarea>
                            <i class="clear-input">
                                <ion-icon name="close-circle"></ion-icon>
                            </i>
                        </div>
                    </div>

                    <div class="mt-1">
                        <button type="submit" class="btn btn-primary btn-lg btn-block">
                            Send
                        </button>
                    </div>

                </form>

            </div>
        </div> --}}
    </div>
@endsection
