@extends('app.base')
@section('content')
    <!-- App Header -->
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" onclick="history.back()" class="headerButton">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">Fale Conosco</div>
        <div class="right">
            <a href="tel:+123456789" class="headerButton">
                <ion-icon name="call-outline"></ion-icon>
            </a>
        </div>
    </div>
    <!-- * App Header -->

    <!-- App Capsule -->
    <div id="appCapsule">

        <div class="section full mt-2">
            <div class="wide-block pt-2 pb-2">
                <form action="{{ route('app.contato.store') }}" method="post">
                    @csrf
                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <input type="text" class="form-control" name="nome" placeholder="Nome">
                            <i class="clear-input">
                                <ion-icon name="close-circle"></ion-icon>
                            </i>
                        </div>
                    </div>
                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <input type="text" class="form-control" name="celular" placeholder="Celular">
                            <i class="clear-input">
                                <ion-icon name="close-circle"></ion-icon>
                            </i>
                        </div>
                    </div>
                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <input type="text" class="form-control" name="assunto" placeholder="Assunto">
                            <i class="clear-input">
                                <ion-icon name="close-circle"></ion-icon>
                            </i>
                        </div>
                    </div>

                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <input type="email" class="form-control" name="email" placeholder="E-mail">
                            <i class="clear-input">
                                <ion-icon name="close-circle"></ion-icon>
                            </i>
                        </div>
                    </div>

                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <textarea name="msg" rows="4" class="form-control" placeholder="Mensagem"></textarea>
                            <i class="clear-input">
                                <ion-icon name="close-circle"></ion-icon>
                            </i>
                        </div>
                    </div>

                    <div class="mt-1">
                        <button id="logar" type="submit" class="btn btn-primary btn-block btn-lg">Enviar</button>
                        <button id="carregando" class="btn btn-lg btn-primary w-100 mb-5" disabled>
                            <span class="spinner-border spinner-border-sm align-middle ms-2"></span> Aguarde...
                         </button>
                    </div>
                </form>
            </div>

        </div>


        <div class="section full mt-2">
            <div class="section-title">Contatos</div>
        </div>
        <ul class="listview image-listview">
            <li>
                <a href="tel:16997322886" class="item">
                    <div class="icon-box bg-facebook">
                        <ion-icon name="call-outline"></ion-icon>
                    </div>
                    <div class="in">
                        +55 (16) 99732-2886
                    </div>
                </a>
            </li>
            <li>
                <a href="tel:16999922886" class="item">
                    <div class="icon-box bg-facebook">
                        <ion-icon name="call-outline"></ion-icon>
                    </div>
                    <div class="in">
                        <div>+55 (16) 99992-2886</div>
                    </div>
                </a>
            </li>
            <li>
                <a href="https://api.whatsapp.com/send?1=pt_BR&phone=5516997322886&text=Olá estou no aplicativo da {{ env('APP_NAME') }} e gostaria de informações" class="item">
                    <div class="icon-box bg-whatsapp">
                        <ion-icon name="logo-whatsapp"></ion-icon>
                    </div>
                    <div class="in">
                        +55 (16) 99732-2886
                    </div>
                </a>
            </li>
            <li>
                <a href="https://api.whatsapp.com/send?1=pt_BR&phone=5516999922886&text=Olá estou no aplicativo da {{ env('APP_NAME') }} e gostaria de informações" class="item">
                    <div class="icon-box bg-whatsapp">
                        <ion-icon name="logo-whatsapp"></ion-icon>
                    </div>
                    <div class="in">
                        <div>+55 (16) 99992-2886</div>
                    </div>
                </a>
            </li>
        </ul>
    </div>
    <div id="success" class="toast-box toast-top bg-success">
        <div class="in">
            <div class="text">
                Mensagem enviada com successo!
            </div>
        </div>
        <button type="button" class="btn btn-sm btn-text-light close-button">OK</button>
    </div>
    <!-- * App Capsule -->
@endsection
@section('js')
<script>
    $(document).ready(function() {
        $("#carregando").hide();
        $("#logar").click(function() {
            $("#logar").hide();
            $("#carregando").show();
        });

        @if (session('flash_message'))
            toastbox('success', 3000)
        @endif
    });
</script>
@endsection
