<!doctype html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title>{{ env('APP_EMPRESA') }}</title>
    <meta name="description" content="{{ env('APP_EMPRESA') }}">
    <meta name="keywords" content="{{ env('APP_EMPRESA') }}" />
    <link rel="icon" type="image/png" href="{{ url('app') }}/assets/img/favicon.png" sizes="32x32">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ url('app') }}/assets/img/icon/192x192.png">
    <link rel="stylesheet" href="{{ url('app') }}/assets/css/style.css">
    <link rel="manifest" href="{{ url('app') }}/__manifest.json">
    <meta property="og:type" content="article" />
    <meta property="og:url" content="@yield('url')">
    <meta property="og:type" content="service">
    <meta property="og:title" content="@yield('title')">
    <meta property="og:description" content="@yield('description')">
    <meta property="og:image" content="@yield('image')" />
    <meta property="og:image:secure_url" content="@yield('image')" />
    <style>
        .sempreDireita{
            position: fixed;
            z-index: 560;
            bottom: 65px;
            width: 100%;
            right: 0;
        }
    </style>
</head>

<body>
    {{-- <div id="loader">
        <div class="spinner-border text-primary" role="status"></div>
    </div> --}}
    @yield('content')
    <!-- App Bottom Menu -->
    {{-- <div class="appBottomMenu bg-primary text-light" style="height: 70px;"> --}}
        {{-- <a href="javascript:;" class="item active" data-toggle="modal" data-target="#sidebarPanel">
            <div class="col">
                <ion-icon name="menu"></ion-icon>
                Menu
            </div>
        </a>
        @if (!empty($active))
            <a href="{{ route('app.categorias',[0,0]) }}" class="item active">
        @else
            <a href="{{ route('app.categorias',[!empty($estado) ? $estado : 0,!empty($cidade) ? $cidade : 0]) }}" class="item">
        @endif
        <div class="col">
                <ion-icon name="apps"></ion-icon>
                Anunciantes
            </div>
        </a>

        @if (!empty($active))
            <a href="{{ route('app.home') }}" class="item active">
        @else
            <a href="{{ route('home.home',[!empty($estado) ? $estado : 0,!empty($cidade) ? $cidade : 0]) }}" class="item">
        @endif
        <div class="col">
                <ion-icon name="home"></ion-icon>
                Home
            </div>
        </a> --}}
        {{-- @if (!empty($cidade))
            <a href="{{ route('home.home',[$estado,$cidade]) }}" class="item active">
                <div class="col">
                    <ion-icon name="home"></ion-icon>
                    Home
                </div>
            </a>
        @else
        <a href="{{route('app.home')}}" class="item active">
            <div class="col">
                <ion-icon name="home"></ion-icon>
                Home
            </div>
        </a>
        @endif --}}
        {{-- <a href="{{route('app.anunciar')}}" class="item active">
            <div class="col">
                <ion-icon name="add-circle"></ion-icon>
                Quero anunciar
            </div>
        </a>
        <a href="{{ route('meu.perfil') }}" class="item active">
            <div class="col">
                <ion-icon name="person"></ion-icon>
                Minha Conta
            </div>
        </a> --}}
    {{-- </div> --}}
    <!-- * App Bottom Menu -->

    <!-- App Sidebar -->
    <div class="modal fade panelbox panelbox-left" id="sidebarPanel" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body p-0">
                    <div class="profileBox">
                        <div class="image-wrapper">
                            <img src="{{ !empty(Auth::user()->foto) ? url("storage/".Auth::user()->foto."") : url('admin/assets/media/user.png')}} " alt="image" class="imaged rounded">
                        </div>
                        <div class="in">
                            <strong>{{ !empty(Auth::user()->name) ? Auth::user()->name : 'Convidado'}}</strong>
                            <div class="text-muted">
                                <ion-icon name="location"></ion-icon>
                                {{ !empty(Auth::user()->cidade) ? Auth::user()->cidade.'-'.Auth::user()->estado : 'São Paulo'}}
                            </div>
                        </div>
                        <a href="javascript:;" class="close-sidebar-button" data-dismiss="modal">
                            <ion-icon name="close"></ion-icon>
                        </a>
                    </div>
                    <!-- * profile box -->

                    <ul class="listview flush transparent no-line image-listview mt-2">
                        {{-- <li>
                            <a href="{{route('app.quem.somos')}}" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="home-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Quem Somos
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="{{route('app.fundadores')}}" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="people-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Fundadores
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('app.perguntas') }}" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="layers-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Perguntas frequentes
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('app.potencias.estados') }}" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="layers-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Lojas Maçônicas
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="{{route('app.eventos')}}" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="layers-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Eventos
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="{{route('app.contato')}}" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="mail-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Fale Conosco
                                </div>
                            </a>
                        </li>
                        <li>
                            <div class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="moon-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    <div>Modo Noturno</div>
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input dark-mode-switch"
                                            id="darkmodesidebar">
                                        <label class="custom-control-label" for="darkmodesidebar"></label>
                                    </div>
                                </div>
                            </div>
                        </li> --}}
                    </ul>
                    {{-- <div class="listview-title mt-2 mb-1">
                        <span>Friends</span>
                    </div>
                    <ul class="listview image-listview flush transparent no-line">
                        <li>
                            <a href="page-chat.html" class="item">
                                <img src="{{ url('app') }}/assets/img/sample/avatar/avatar7.jpg" alt="image"
                                    class="image">
                                <div class="in">
                                    <div>Sophie Asveld</div>
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="page-chat.html" class="item">
                                <img src="{{ url('app') }}/assets/img/sample/avatar/avatar3.jpg" alt="image"
                                    class="image">
                                <div class="in">
                                    <div>Sebastian Bennett</div>
                                    <span class="badge badge-danger">6</span>
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="page-chat.html" class="item">
                                <img src="{{ url('app') }}/assets/img/sample/avatar/avatar10.jpg" alt="image"
                                    class="image">
                                <div class="in">
                                    <div>Beth Murphy</div>
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="page-chat.html" class="item">
                                <img src="{{ url('app') }}/assets/img/sample/avatar/avatar2.jpg" alt="image"
                                    class="image">
                                <div class="in">
                                    <div>Amelia Cabal</div>
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="page-chat.html" class="item">
                                <img src="{{ url('app') }}/assets/img/sample/avatar/avatar5.jpg" alt="image"
                                    class="image">
                                <div class="in">
                                    <div>Henry Doe</div>
                                </div>
                            </a>
                        </li>
                    </ul> --}}
                </div>

                <!-- sidebar buttons -->
                {{-- <div class="sidebar-buttons"> --}}
                    {{-- <a href="{{ route('meu.perfil') }}" class="btn btn-text-primary">
                        <ion-icon name="person-outline"></ion-icon>
                    </a>
                    <a href="{{ route('meu.perfil') }}#friends" class="btn btn-text-primary">
                        <ion-icon name="heart-outline"></ion-icon>
                    </a>
                    <a href="{{ route('meu.perfil') }}#settings" class="btn btn-text-primary">
                        <ion-icon name="settings-outline"></ion-icon>
                    </a>
                    <form method="POST" action="{{ route('logout') }}">
                        <input type="hidden" value="3" name="tipo">
                        @csrf
                        <button href="{{ route('logout') }}" onclick="event.preventDefault(); this.closest('form').submit();" class="btn btn-text-primary">
                            <ion-icon name="log-out-outline"></ion-icon>
                        </button>
                    </form> --}}
                {{-- </div> --}}
                <!-- * sidebar buttons -->
            </div>
        </div>
    </div>
    <!-- * App Sidebar -->

    <!-- welcome notification  -->
    @yield('download')
    <script src="{{ url('app') }}/assets/js/lib/jquery-3.4.1.min.js"></script>
    <script src="{{ url('app') }}/assets/js/lib/popper.min.js"></script>
    <script src="{{ url('app') }}/assets/js/lib/bootstrap.min.js"></script>
    <script type="module" src="https://unpkg.com/ionicons@5.2.3/dist/ionicons/ionicons.js"></script>
    <script src="{{ url('app') }}/assets/js/plugins/owl-carousel/owl.carousel.min.js"></script>
    <script src="{{ url('app') }}/assets/js/plugins/jquery-circle-progress/circle-progress.min.js"></script>
    <script src="{{ url('app') }}/assets/js/base.js"></script>

    <script>
        // Trigger welcome notification after 5 seconds
        setTimeout(() => {
            notification('download');
        }, 2000);
    </script>

    @yield('js')
</body>

</html>

