<div class="listview-title mt-2">Categorias</div>
<ul class="listview image-listview media mb-2">
    @foreach ($level1 as $item)
    <li>
        <a href="{{ route('app.anuncios.categoria',[$item->categoria_id,$estado,$cidade]) }}" class="item">
            <div class="imageWrapper">
                <img src="{{ url("storage/{$item->categoria->ico}") }}" alt="image" class="imaged w64">
            </div>
            <div class="in">
                <div>
                    {{ $item->categoria->titulo }}
                    <div class="text-muted">{{ count($qtd_level1) }} anúncios</div>
                </div>
            </div>
        </a>
    </li>
    @endforeach
</ul>


<div class="listview-title mt-2">Sub Categorias</div>
<ul class="listview link-listview">
    @foreach ($level2 as $item)
        <li>
            <a href="{{ route('app.categoria.level2',[$item->level1_id,$item->level2_id,$estado,$cidade]) }}">
                {{ $item->level2 }}
                <span class="badge badge-primary">{{ count($qtd_level2) }} anuncios</span>
            </a>
        </li>
    @endforeach
</ul>

<ul class="listview image-listview media search-result mb-2">
    @foreach ($anuncios as $anuncio)
    <li>
        <a href="#" onclick="javascript:window.open('{{route('app.anuncio',$anuncio->id)}}', '_self')"  class="item">
            @if (!empty($anuncio->thumb))
                <div class="imageWrapper">
                    <img src="{{ url("storage/{$anuncio->thumb}") }}" class="imaged corta-img">
                </div>
            @endif
            <div class="in">
                <div>
                    <h4 style="margin-top: -20px;" class="mb-05">{{lmWord($anuncio->empresa, 30)}}</h4>
                    <h4 style="" class="mb-05">{{!empty($anuncio->anunciante->tratamento) ? $anuncio->anunciante->tratamento : ''}} {{!empty($anuncio->anunciante->name) ? $anuncio->anunciante->name : ''}}</h4>
                    <h4 style="" class="mb-05">{{$anuncio->cidade}}/{{$anuncio->estado}}</strong>{{!empty($anuncio->bairro) ? ' - '.$anuncio->bairro : ''}}</h4>
                </div>
            </div>
        </a>
    </li>
    @endforeach
</ul>
<div class="section mt-3 mb-3">
    <a href="{{ route('app.categorias',[$estado,$cidade]) }}" class="btn btn-primary btn-block">Listar Categorias</a>
</div>
