<!DOCTYPE html>
<html lang="zxx">

<head>
    <title>{{ env('APP_NAME') }} ATESTADO DE SAÚDE - {{ $animal->nome }},
        {{ $animal->raca_nome }} emitica por {{ $user->sexo }} {{ $user->name }} CRMV {{ $user->crmv }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta charset="UTF-8">

    <!-- External CSS libraries -->
    <link type="text/css" rel="stylesheet" href="{{ url('prints') }}/assets/css/bootstrap.min.css">
    <link type="text/css" rel="stylesheet"
        href="{{ url('prints') }}/assets/fonts/font-awesome/css/font-awesome.min.css">

    <!-- Favicon icon -->
    <link rel="shortcut icon" href="{{ url('prints') }}/assets/img/favicon.ico" type="image/x-icon">

    <!-- Google fonts -->
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&amp;display=swap"
        rel="stylesheet">

    <!-- Custom Stylesheet -->
    <link type="text/css" rel="stylesheet" href="{{ url('prints') }}/assets/css/style.css">
</head>

<body>
    <?php
    $date1 = date('Y-m-d', strtotime($animal->nascimento));

    $date2 = date('Y-m-d');
    $diff = abs(strtotime($date2) - strtotime($date1));

    $years = floor($diff / (365 * 60 * 60 * 24));
    $months = floor(($diff - $years * 365 * 60 * 60 * 24) / (30 * 60 * 60 * 24));
    $days = floor(($diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24) / (60 * 60 * 24));
    ?>
    <!-- Invoice 6 start -->
    <div class="invoice-6 invoice-content">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="invoice-inner-6" id="invoice_wrapper">
                        <div class="invoice-top">
                            <div class="row">
                                <div class="col-sm-4">
                                    <div>
                                        <img width="70" src="{{ url('adm') }}/assets/media/logos/logo.png"
                                            alt="logo">
                                    </div>
                                </div>
                                <div class="col-sm-8">
                                    <div class="invoice text-right">
                                        <h5>ATESTADO DE SAÚDE</h5>
                                        <h4>{{ $clinica->fantasia }}</h4>
                                        <h5>CNPJ: {{ formatCnpjCpf($clinica->cnpj) }}</h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="invoice-titel">
                            <div class="row">
                                <div class="invoice2 col-sm-6">
                                    <h3>{{ $animal->nome }} - {{ utf8_decode($animal->raca_nome) }}</h3>
                                </div>
                                <div class="date col-sm-6 text-end">
                                    <h3>Data da emissão <span>{{ date('d/m/Y', strtotime($termo->created_at)) }}</span>
                                    </h3>
                                </div>
                            </div>
                        </div>
                        <div class="order-summary">
                            <p>
                                Eu, <strong>{{$user->name}}</strong>, possuidor do CRMV <strong>{{$user->crmv}}</strong>, atesto por minha honra profissional, ter nesta data observado o animal <strong>{{$animal->nome}}</strong>, <strong>{{utf8_decode($animal->especie_nome)}}</strong>, raça <strong>{{utf8_decode($animal->raca_nome)}}</strong>, do sexo <strong>{{$animal->sexo}}</strong>, nascido em <strong>{{date('d/m/Y', strtotime($animal->nascimento))}}</strong>, apresentado sob responsabilidade do(a) <strong>{{$cliente->name}}</strong>, portador do RG: <strong>{{$cliente->rg}}</strong>, CPF: <strong>{{$cliente->cpf}}</strong> sito à, <strong>{{$cliente->endereco}}, {{$cliente->numero}} {{$cliente->complemento}}, {{$cliente->bairro}}, {{$cliente->cidade}}-{{$cliente->estado}}</strong> CEP: <strong>{{$cliente->cep}}</strong>.
                                Atesto que referido animal não apresenta quaisquer sinais de doença infectocontagiosa característicos da espécie, o qual apresentou bom estado geral de saúde durante o exame clínico e foi desparasitado com um anti-helmíntico de amplo espectro.
                                Por ser expressão da verdade, passo o presente atestado que assino, dato e carimbo.
                            </p>
                        </div>
                        <div class="invoice-informeshon">
                            <div class="row mt-4">
                                <div class="col-sm-12">
                                    <p class="text-1 text-center">
                                        <img width="200px" src="{{ $user->assinatura }}">
                                        <br>
                                        {{ $user->sexo }} {{ $user->name }}<br>
                                        CRMV: {{ $user->crmv }}
                                    </p>
                                    <p class="text-1 text-center">
                                        <img src="{{ url('adm') }}/assets/images/email.png" width="15">
                                        {{ $clinica->email }} <img
                                            src="{{ url('adm') }}/assets/images/zap-azul.png" width="15">
                                        {{ $clinica->celular }} <img
                                            src="{{ url('adm') }}/assets/images/instagram.png" width="15">
                                        {{ $clinica->instagram }}
                                    </p>
                                    @if ($clinica->rodape == 1)
                                        <p class="text-1 text-center">
                                            {{ $clinica->endereco }}, {{ $clinica->numero }}
                                            {{ $clinica->complemento }}, {{ $clinica->bairro }},
                                            {{ $clinica->cidade }}-{{ $clinica->estado }} CEP: {{ $clinica->cep }}
                                        </p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="invoice-btn-section clearfix d-print-none">
                        <a href="javascript:window.print()" class="btn btn-lg btn-print">
                            <i class="fa fa-print"></i> Imprimir
                        </a>
                        <a id="invoice_download_btn" class="btn btn-lg btn-download">
                            <i class="fa fa-download"></i> Baixar
                        </a>
                        <a target="_blank" href="https://api.whatsapp.com/send?text=Olá segue o *{{$termo->titulo}}* Acesse a termo pelo link: {{env('APP_URL')}}/print/{{setUri($termo->titulo)}}/{{$termo->id}}, emitida por *{{$user->sexo}} {{$user->name}} CRMV {{$user->crmv}}*" class="btn btn-lg btn-success">
                            <img src="{{url('adm')}}/assets/images/whatsapp-logo-branca.png" width="15"> Compartilhar
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Invoice 6 end -->

    <script src="{{ url('prints') }}/assets/js/jquery.min.js"></script>
    <script src="{{ url('prints') }}/assets/js/jspdf.min.js"></script>
    <script src="{{ url('prints') }}/assets/js/html2canvas.js"></script>
    <script src="{{ url('prints') }}/assets/js/app.js"></script>
</body>

</html>
