<!DOCTYPE html>
<html lang="zxx">

<head>
    <title>{{ env('APP_NAME') }} Atendimento Nº {{ $atendimento->id }} do animal {{ $animal->nome }},
        {{ $animal->raca }} emitida por {{ $user->sexo }} {{ $user->nome }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta charset="UTF-8">

    <!-- External CSS libraries -->
    <link type="text/css" rel="stylesheet" href="{{ url('prints') }}/assets/css/bootstrap.min.css">
    <link type="text/css" rel="stylesheet"
        href="{{ url('prints') }}/assets/fonts/font-awesome/css/font-awesome.min.css">

    <!-- Favicon icon -->
    <link rel="shortcut icon" href="{{ url('prints') }}/assets/img/favicon.ico" type="image/x-icon">

    <!-- Google fonts -->
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&amp;display=swap"
        rel="stylesheet">

    <!-- Custom Stylesheet -->
    <link type="text/css" rel="stylesheet" href="{{ url('prints') }}/assets/css/style.css">
</head>

<body>

    <!-- Invoice 6 start -->
    <div class="invoice-6 invoice-content">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="invoice-inner-6" id="invoice_wrapper">
                        <div class="invoice-top">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div>
                                        <img width="70" src="{{ url('adm') }}/assets/media/logos/logo.png"
                                            alt="logo">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="invoice">
                                        <h1>Atendimento Nº {{ $atendimento->id }}</h1>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="invoice-titel">
                            <div class="row">
                                <div class="invoice2 col-sm-6">
                                    <h3>{{ $animal->nome }} - {{ utf8_decode($animal->raca_nome) }}</h3>
                                </div>
                                <div class="date col-sm-6 text-end">
                                    <h3>Data da emissão
                                        <span>{{ date('d/m/Y', strtotime($atendimento->created_at)) }}</span></h3>
                                </div>
                            </div>
                        </div>
                        <div class="invoice-info border-bottom">
                            <div class="row">
                                <div class="col-sm-6 mb-30">
                                    <div class="invoice-number">
                                        <h4 class="inv-title-1">Cliente</h4>
                                        <p class="invo-addr-1">
                                            Nome: {{ $cliente->name }} <br />
                                            Telefone: {{ $cliente->celular }} <br />
                                            Endereço: {{ $cliente->endereco }}, {{ $cliente->numeno }},
                                            {{ $cliente->complemento }} {{ $cliente->bairro }},
                                            {{ $cliente->cidade }}-{{ $cliente->estado }} CEP: {{ $cliente->cep }}
                                            <br />
                                        </p>
                                    </div>
                                </div>
                                <div class="col-sm-6 mb-30">
                                    <div class="invoice-number text-end">
                                        <h4 class="inv-title-1">Animal</h4>
                                        <p class="invo-addr-1">
                                            Nome: {{ $animal->nome }}<br />
                                            Espécie: {{ $animal->especie }} |
                                            Raça: {{ utf8_decode($animal->raca_nome) }} <br />
                                            Idade:
                                            <?php
                                            $date1 = date('Y-m-d', strtotime($animal->nascimento));
                                            $date2 = date('Y-m-d');
                                            $diff = abs(strtotime($date2) - strtotime($date1));

                                            $years = floor($diff / (365 * 60 * 60 * 24));
                                            $months = floor(($diff - $years * 365 * 60 * 60 * 24) / (30 * 60 * 60 * 24));
                                            $days = floor(($diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24) / (60 * 60 * 24));
                                            printf("%d ano(s), %d mese(s), %d dia(s)\n", $years, $months, $days);
                                            ?>
                                            <br />
                                            Sexo: {{ $animal->sexo }} |
                                            Castrado: {{ $animal->castrado }} |
                                            Peso: {{ $animal->peso }}<br />
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="order-summary">
                            <div class="table-responsive">
                                <table class="table invoice-table">
                                    <thead class="bg-active">
                                        <tr>
                                            <th>Relatório Geral</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($anamneses as $anamnese)
                                        <tr>
                                           <td>
                                            @foreach ($anamnese->Form as $titulo)
                                                <h5>{{$titulo->value}}</h5>
                                            @endforeach
                                                {{$anamnese->value}}
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="order-summary">
                            <div class="table-responsive">
                                <table class="table invoice-table">
                                    <thead class="bg-active">
                                        <tr>
                                            <th>Receitas</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($receitas as $receita)
                                        <tr>
                                           <td>{!! $receita->descricao !!}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="order-summary">
                            <div class="table-responsive">
                                <table class="table invoice-table">
                                    <thead class="bg-active">
                                        <tr>
                                            <th>Anexos</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                           <td>
                                            @foreach ($arquivos as $arquivo)
                                               @if ($extensao[$arquivo->ext] == 'file')
                                               <a href="{{url("storage/{$arquivo->image}")}}" target="_blank">
                                                    <img width="200" src="{{ url('adm') }}/assets/images/{{$arquivo->ext}}.png">
                                               </a>
                                                @else
                                                <a  href="{{url("storage/{$arquivo->image}")}}" target="_blank">
                                                    <img width="200" src="{{url("storage/{$arquivo->image}")}}">
                                                </a>
                                               @endif
                                               @endforeach
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="invoice-informeshon">
                            <div class="row mt-4">
                                <div class="col-sm-12">
                                    <p class="text-1 text-center">
                                        <img width="200px" src="{{ $user->assinatura }}">
                                        <br>
                                        {{ $user->sexo }} {{ $user->name }}<br>
                                        CRMV: {{ $user->crmv }}
                                    </p>
                                    <p class="text-1 text-center">
                                        <img src="{{ url('adm') }}/assets/images/email.png" width="15">
                                        {{ $clinica->email }} <img
                                            src="{{ url('adm') }}/assets/images/zap-azul.png" width="15">
                                        {{ $clinica->celular }} <img
                                            src="{{ url('adm') }}/assets/images/instagram.png" width="15">
                                        {{ $clinica->instagram }}
                                    </p>
                                    @if ($clinica->rodape == 1)
                                        <p class="text-1 text-center">
                                            {{ $clinica->endereco }}, {{ $clinica->numero }}
                                            {{ $clinica->complemento }}, {{ $clinica->bairro }},
                                            {{ $clinica->cidade }}-{{ $clinica->estado }} CEP: {{ $clinica->cep }}
                                        </p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="invoice-btn-section clearfix d-print-none">
                        <a href="javascript:window.print()" class="btn btn-lg btn-print">
                            <i class="fa fa-print"></i> Imprimir
                        </a>
                        <a id="invoice_download_btn" class="btn btn-lg btn-download">
                            <i class="fa fa-download"></i> Baixar
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Invoice 6 end -->

    <script src="{{ url('prints') }}/assets/js/jquery.min.js"></script>
    <script src="{{ url('prints') }}/assets/js/jspdf.min.js"></script>
    <script src="{{ url('prints') }}/assets/js/html2canvas.js"></script>
    <script src="{{ url('prints') }}/assets/js/app.js"></script>
</body>

</html>
