@extends('layouts.base')
@section('titulo', 'Perfil do Cliente')
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="toolbar" id="kt_toolbar">
            <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
                <div data-kt-swapper="true" data-kt-swapper-mode="prepend"
                    data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}"
                    class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                    <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">Meus dados</h1>
                    <span class="h-20px border-gray-200 border-start mx-4"></span>
                    <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                        <li class="breadcrumb-item text-muted">
                            <a href="{{ route('home') }}" class="text-muted text-hover-primary">Home</a>
                        </li>
                        <li class="breadcrumb-item"><span class="bullet bg-gray-200 w-5px h-2px"></span></li>
                        <li class="breadcrumb-item text-dark">{{ Auth::user()->name }}</li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-xxl">
                @if (session('message'))
                    <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                        <span class="svg-icon svg-icon-2hx svg-icon-danger me-4">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path opacity="0.3"
                                    d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z"
                                    fill="black"></path>
                                <path
                                    d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z"
                                    fill="black"></path>
                            </svg>
                        </span>
                        <div class="d-flex flex-column">
                            <h4 class="mb-1 text-danger">{{ session('message') }}</h4>
                        </div>
                    </div>
                @endif
                @if (session('success'))
                    <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                        <span class="svg-icon svg-icon-2hx svg-icon-success me-4">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path opacity="0.3"
                                    d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z"
                                    fill="black"></path>
                                <path
                                    d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z"
                                    fill="black"></path>
                            </svg>
                        </span>
                        <div class="d-flex flex-column">
                            <h4 class="mb-1 text-success">{{ session('success') }}</h4>
                        </div>
                    </div>
                @endif

                @include('admin.perfil.base')

                <!--begin::CONTEÚDO DINÂMICO-->
                <div class="card">
                    <!--begin::Header-->
                    <div class="card-header card-header-stretch">
                        <!--begin::Title-->
                        <div class="card-title">
                            <h3 class="m-0 text-gray-800">Faturas</h3>
                        </div>
                        <!--end::Title-->
                        <!--begin::Toolbar-->
                        <div class="card-toolbar m-0">
                            <!--begin::Tab nav-->
                            <ul class="nav nav-stretch fs-5 fw-bold nav-line-tabs border-transparent" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a id="kt_referrals_year_tab" class="nav-link text-active-gray-800 active"
                                        data-bs-toggle="tab" role="tab" href="#kt_referrals_1">Todas</a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a id="kt_referrals_2019_tab" class="nav-link text-active-success-800 me-4"
                                        data-bs-toggle="tab" role="tab" href="#kt_referrals_2">Pagas</a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a id="kt_referrals_2018_tab" class="nav-link text-active-danger-800 me-4"
                                        data-bs-toggle="tab" role="tab" href="#kt_referrals_3">Pendentes</a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a id="kt_referrals_2017_tab" class="nav-link text-active-warning-800 ms-8"
                                        data-bs-toggle="tab" role="tab" href="#kt_referrals_4">Canceladas</a>
                                </li>
                            </ul>
                            <!--end::Tab nav-->
                        </div>
                        <!--end::Toolbar-->
                    </div>
                    <!--end::Header-->
                    <!--begin::Tab Content-->
                    <div id="kt_referred_users_tab_content" class="tab-content">
                        <!--begin::Tab panel-->
                        <div id="kt_referrals_1" class="card-body p-0 tab-pane fade show active" role="tabpanel">
                            <div class="table-responsive">
                                <!--begin::Table-->
                                <table class="table table-flush align-middle table-row-bordered table-row-solid gy-4 gs-9">
                                    <!--begin::Thead-->
                                    <thead class="border-gray-200 fs-5 fw-bold bg-lighten">
                                        <tr>
                                            <th class="min-w-175px ps-9">Vencimento</th>
                                            <th class="min-w-150px px-0">Nº</th>
                                            <th class="min-w-350px">Ref</th>
                                            <th class="min-w-125px">Valor</th>
                                            <th class="min-w-125px text-center"></th>
                                        </tr>
                                    </thead>
                                    <!--end::Thead-->
                                    <!--begin::Tbody-->
                                    <tbody class="fs-6 fw-bold text-gray-600">
                                        @foreach ($faturas as $fatura)
                                            <tr>
                                                <td class="ps-9">
                                                    {{ date('d/m/Y', strtotime($fatura->vencimento)) }}</td>
                                                <td class="ps-0">{{ $fatura->id }}</td>
                                                <td>{{ $fatura->ref }}</td>
                                                <td>R$ {{ moeda($fatura->valor) }}</td>
                                                <td>
                                                    <div
                                                        class="badge badge-light-{{ $fatura->status == 1 ? 'danger' : 'success' }} fw-bolder">
                                                        {{ $fatura->status == 1 ? 'Pendente' : 'Pago' }}</div><br>
                                                </td>
                                                <td class="text-center">
                                                    @if ($fatura->status == 2)
                                                        <a href="{{route('fatura',$fatura->id)}}" target="_blank" class="btn btn-success btn-sm btn-active-light-success">Recibo</a>
                                                    @else
                                                        @if (empty($fatura->link))
                                                        <a href="{{url("gerencianet/index.php?id=".$fatura->id."")}}" target="_blank" class="btn btn-danger btn-sm btn-active-light-danger">Gerar Fatura</a>
                                                        @else
                                                            <a href="#" class="btn btn-danger btn-sm btn-active-light-danger">Gerar 2ª Via</a>
                                                        @endif
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!--end::Tab panel-->
                        <!--begin::Tab panel-->
                        <div id="kt_referrals_2" class="card-body p-0 tab-pane fade" role="tabpanel">
                            <div class="table-responsive">
                                <!--begin::Table-->
                                <table class="table table-flush align-middle table-row-bordered table-row-solid gy-4 gs-9">
                                    <!--begin::Thead-->
                                    <thead class="border-gray-200 fs-5 fw-bold bg-lighten">
                                        <tr>
                                            <th class="min-w-175px ps-9">Vencimento</th>
                                            <th class="min-w-150px px-0">Nº</th>
                                            <th class="min-w-350px">Ref</th>
                                            <th class="min-w-125px">Valor</th>
                                            <th class="min-w-125px text-center"></th>
                                        </tr>
                                    </thead>
                                    <!--end::Thead-->
                                    <!--begin::Tbody-->
                                    <tbody class="fs-6 fw-bold text-gray-600">
                                        @foreach ($pagas as $fatura)
                                            <tr>
                                                <td class="ps-9">
                                                    {{ date('d/m/Y', strtotime($fatura->vencimento)) }}</td>
                                                <td class="ps-0">{{ $fatura->id }}</td>
                                                <td>{{ $fatura->ref }}</td>
                                                <td>R$ {{ moeda($fatura->valor) }}</td>
                                                <td>
                                                    <div
                                                        class="badge badge-light-{{ $fatura->status == 1 ? 'danger' : 'success' }} fw-bolder">
                                                        {{ $fatura->status == 1 ? 'Pendente' : 'Pago' }}</div><br>
                                                </td>
                                                <td class="text-center">
                                                    @if ($fatura->status == 2)
                                                    <a href="{{route('fatura',$fatura->id)}}" target="_blank" class="btn btn-success btn-sm btn-active-light-success">Recibo</a>
                                                    @else
                                                        @if (empty($fatura->status))
                                                            <a href="#"
                                                                class="btn btn-danger btn-sm btn-active-light-danger">Gerar
                                                                Fatura</a>
                                                        @else
                                                            <a href="#"
                                                                class="btn btn-danger btn-sm btn-active-light-danger">Gerar
                                                                2ª Via</a>
                                                        @endif
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <!--end::Tbody-->
                                </table>
                                <!--end::Table-->
                            </div>
                        </div>
                        <!--end::Tab panel-->
                        <!--begin::Tab panel-->
                        <div id="kt_referrals_3" class="card-body p-0 tab-pane fade" role="tabpanel">
                            <div class="table-responsive">
                                <!--begin::Table-->
                                <table class="table table-flush align-middle table-row-bordered table-row-solid gy-4 gs-9">
                                    <!--begin::Thead-->
                                    <thead class="border-gray-200 fs-5 fw-bold bg-lighten">
                                        <tr>
                                            <th class="min-w-175px ps-9">Vencimento</th>
                                            <th class="min-w-150px px-0">Nº</th>
                                            <th class="min-w-350px">Ref</th>
                                            <th class="min-w-125px">Valor</th>
                                            <th class="min-w-125px text-center"></th>
                                        </tr>
                                    </thead>
                                    <!--end::Thead-->
                                    <!--begin::Tbody-->
                                    <tbody class="fs-6 fw-bold text-gray-600">
                                        @foreach ($pendentes as $fatura)
                                        <tr>
                                            <td class="ps-9">
                                                {{ date('d/m/Y', strtotime($fatura->vencimento)) }}</td>
                                            <td class="ps-0">{{ $fatura->id }}</td>
                                            <td>{{ $fatura->ref }}</td>
                                            <td>R$ {{ moeda($fatura->valor) }}</td>
                                            <td>
                                                <div
                                                    class="badge badge-light-{{ $fatura->status == 1 ? 'danger' : 'success' }} fw-bolder">
                                                    {{ $fatura->status == 1 ? 'Pendente' : 'Pago' }}</div><br>
                                            </td>
                                            <td class="text-center">
                                                @if ($fatura->status == 2)
                                                <a href="{{route('fatura',$fatura->id)}}" target="_blank" class="btn btn-success btn-sm btn-active-light-success">Recibo</a>
                                                @else
                                                    @if (empty($fatura->status))
                                                        <a href="#"
                                                            class="btn btn-danger btn-sm btn-active-light-danger">Gerar
                                                            Fatura</a>
                                                    @else
                                                        <a href="#"
                                                            class="btn btn-danger btn-sm btn-active-light-danger">Gerar
                                                            2ª Via</a>
                                                    @endif
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                    <!--end::Tbody-->
                                </table>
                                <!--end::Table-->
                            </div>
                        </div>
                        <!--end::Tab panel-->
                        <!--begin::Tab panel-->
                        <div id="kt_referrals_4" class="card-body p-0 tab-pane fade" role="tabpanel">
                            <div class="table-responsive">
                                <!--begin::Table-->
                                <table class="table table-flush align-middle table-row-bordered table-row-solid gy-4 gs-9">
                                    <!--begin::Thead-->
                                    <thead class="border-gray-200 fs-5 fw-bold bg-lighten">
                                        <tr>
                                            <th class="min-w-175px ps-9">Vencimento</th>
                                            <th class="min-w-150px px-0">Nº</th>
                                            <th class="min-w-350px">Ref</th>
                                            <th class="min-w-125px">Valor</th>
                                            <th class="min-w-125px text-center"></th>
                                        </tr>
                                    </thead>
                                    <!--end::Thead-->
                                    <!--begin::Tbody-->
                                    <tbody class="fs-6 fw-bold text-gray-600">
                                        @foreach ($canceladas as $fatura)
                                            <tr>
                                                <td class="ps-9">{{ date('d/m/Y', strtotime($fatura->vencimento)) }}</td>
                                                <td class="ps-0">{{ $fatura->id }}</td>
                                                <td>{{ $fatura->ref }}</td>
                                                <td>R$ {{ moeda($fatura->valor) }}</td>
                                                <td>
                                                    <div
                                                        class="badge badge-light-{{ $fatura->status == 1 ? 'danger' : 'success' }} fw-bolder">
                                                        {{ $fatura->status == 1 ? 'Pendente' : 'Pago' }}</div><br>
                                                </td>
                                                <td class="text-center">
                                                    @if ($fatura->status == 2)
                                                        <a href="{{route('fatura',$fatura->id)}}" target="_blank" class="btn btn-success btn-sm btn-active-light-success">Recibo</a>
                                                    @else
                                                        @if (empty($fatura->status))
                                                            <a href="#" class="btn btn-danger btn-sm btn-active-light-danger">Gerar Fatura</a>
                                                        @else
                                                            <a href="#" class="btn btn-danger btn-sm btn-active-light-danger">Gerar 2ª Via</a>
                                                        @endif
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <!--end::Tbody-->
                                </table>
                                <!--end::Table-->
                            </div>
                        </div>
                        <!--end::Tab panel-->
                    </div>
                </div>
                <!--begin::CONTEÚDO DINÂMICO-->
            </div>
        </div>
    </div>
@endsection
@section('css')
    <link rel="shortcut icon" href="{{ url('adm') }}/assets/media/logos/favicon.ico" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
    <link href="{{ url('adm') }}/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet"
        type="text/css" />
    <link href="{{ url('adm') }}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
@endsection

@section('js')
    <script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/scripts.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/account/settings/deactivate-account.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/two-factor-authentication.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/widgets.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/chat/chat.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/create-app.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/upgrade-plan.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/intro.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/authentication/password-reset/new-password.js"></script>

    <script>
        $(document).ready(function() {
            $("#anual").hide();

            $("#mudar").on("click", function() {
                Swal.fire({
                    title: 'Atenção!',
                    text: 'Deseja realmente mudar seu plano?',
                    icon: 'info',
                    showCancelButton: true,
                    confirmButtonText: 'Sim',
                    cancelButtonText: 'Não',
                    customClass: {
                        confirmButton: 'btn btn-success',
                        cancelButton: 'btn btn-danger'
                    },
                }).then((result) => {
                    if (result.value) {
                        Swal.fire(
                            'Aguarde...',
                            'Seu novo plano esta sendo configurado',
                            'success'
                        )
                        document.getElementById("UpdatePlano").submit();
                    } else if (result.dismiss === Swal.DismissReason.cancel) {
                        Swal.fire(
                            'Cancelado',
                            'Solicitação cancelada',
                            'error'
                        )
                    }
                });
            });
        });

        function Periodo(id) {
            if (id == 1) {
                $("#valorperido").val(1);
            } else if (id == 12) {
                $("#valorperido").val(12);
            }
        }
    </script>
@endsection
