@extends('layouts.base')
@section('titulo', 'Vacinação')
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        @include('admin.atendimentos.consultas.anamnese.topo')
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-xxl">
                @if (session('success'))
                    <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                        <span class="svg-icon svg-icon-2hx svg-icon-success me-4">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path opacity="0.3"
                                    d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z"
                                    fill="black"></path>
                                <path
                                    d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z"
                                    fill="black"></path>
                            </svg>
                        </span>
                        <div class="d-flex flex-column">
                            <h4 class="mb-1 text-success">{{ session('success') }}</h4>
                        </div>
                    </div>
                @endif
                @include('admin.atendimentos.consultas.anamnese.base')

                <!--CONTEÚDO DINÂMICO-->
                <form action="{{ route('app.programacao.vacinacao') }}" method="POST">
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title fs-3 fw-bolder">{{ utf8_decode($vacina->protocolo->protocolo) }}</div>
                        </div>
                        <div class="card-body">
                            @foreach ($vacinacoes as $vacinacao)
                                <div class="row mb-8">
                                    <div class="col-xl-3">
                                        <div class="fs-6 fw-bold mt-2 mb-3">Programação</div>
                                        <input {{$vacinacao->programacao == NULL ? '' : 'disabled="disabled"'}} type="text" id="programacao{{ $vacinacao->id }}"
                                            class="form-control form-control-solid tpc data border-danger"
                                            value="{{$vacinacao->programacao == NULL ? date('d/m/Y') : date('d/m/Y', strtotime($vacinacao->programacao))}}">
                                    </div>
                                    <div class="col-xl-3">
                                        <div class="fs-6 fw-bold mt-2 mb-3">Aplicação</div>
                                        <input type="text" id="aplicacao{{ $vacinacao->id }}"
                                            class="form-control form-control-solid tpc data"
                                            value="{{ empty($vacinacao->aplicacao) ? '' : date('d/m/Y', strtotime($vacinacao->aplicacao)) }}">
                                    </div>
                                    <div class="col-xl-3">
                                        <div class="fs-6 fw-bold mt-2 mb-3">Laboratório</div>
                                        <input type="text" id="laboratorio{{ $vacinacao->id }}"
                                            class="form-control form-control-solid tpc"
                                            value="{{ $vacinacao->laboratorio }}">
                                    </div>
                                    <div class="col-xl-2">
                                        <div class="fs-6 fw-bold mt-2 mb-3">Lote</div>
                                        <input type="text" id="lote{{ $vacinacao->id }}"
                                            class="form-control form-control-solid tpc" value="{{ $vacinacao->lote }}">
                                    </div>
                                    <div class="col-xl-1">
                                        <div class="fs-6 fw-bold mt-2 mb-3">Ações</div>
                                        <button type="button" onclick="javascript:Salvar({{ $vacinacao->id }});"
                                            class="btn btn-icon btn-success w-30px h-30px me-3">
                                            <i class="fa fa-check"></i>
                                        </button>
                                        <a href="{{ route('vacinacao.destroy', $vacinacao->id) }}"
                                            class="btn btn-icon btn-danger w-30px h-30px"
                                            data-kt-permissions-table-filter="delete_row">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                            <div class="row mb-8">
                                <div class="col-xl-12">
                                    <div class="fs-6 fw-bold mt-2 mb-3">Observações</div>
                                    <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                        <textarea id="observacoes" name="observacoes"
                                            class="form-control form-control-solid"
                                            rows="5">{{ $vacina->observacoes }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer d-flex justify-content-end py-6">
                                @csrf
                                <input type="hidden" name="empresa_id" value="{{$clinica->id}}">
                                <input type="hidden" name="user_id" value="{{Auth::user()->id}}">
                                <input type="hidden" name="cliente_id" value="{{$cliente->id}}">
                                <input type="hidden" name="atendimento_id" value="{{$atendimento->id}}">
                                <input type="hidden" name="animal_id" value="{{$animal->id}}">
                                <input type="hidden" name="tipo_id" value="{{$vacina->tipo->id}}">
                                <input type="hidden" name="protocolo_id" value="{{$vacina->protocolo->id}}">
                                <input type="hidden" name="vacina_id" value="{{$vacina->id}}">
                                <button type="submit" name="executar" class="btn btn-danger me-auto">Adicionar Programação</button>
                            <a href="{{route('atendimento.protocolos',$atendimento->id)}}"class="btn btn-primary">Salvar Programação</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('css')
    <link rel="shortcut icon" href="{{ url('adm') }}/assets/media/logos/favicon.ico" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
    <link href="{{ url('adm') }}/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet"
        type="text/css" />
    <link href="{{ url('adm') }}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
@endsection

@section('js')

    <script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/scripts.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/account/settings/signin-methods.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/account/settings/profile-details.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/account/settings/deactivate-account.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/two-factor-authentication.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/widgets.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/chat/chat.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/create-app.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/upgrade-plan.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/intro.js"></script>

    <script src="{{ url('adm') }}/assets/js/custom/apps/subscriptions/add/advanced.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/subscriptions/add/customer-select.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/subscriptions/add/products.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/new-card.js"></script>

    <script>
        Inputmask({
            "mask": "99/99/9999"
        }).mask(".data");

        function Salvar(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('update.vacinacao') }}",
                method: 'POST',
                data: {
                    vacinacao: id,
                    programacao: $("#programacao" + id).val(),
                    aplicacao: $("#aplicacao" + id).val(),
                    laboratorio: $("#laboratorio" + id).val(),
                    lote: $("#lote" + id).val(),
                    observacoes: $("#observacoes").val(),
                },
                success: function(result) {
                    toastr.success("Informações gravadas", "Finalizado");
                }
            });
        }
    </script>


@endsection
