@extends('layouts.base')
@section('titulo', 'Perfil Cliente')
@section('content')
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="toolbar" id="kt_toolbar">
       <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
            <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">{{$cliente->name}}</h1>
                <span class="h-20px border-gray-200 border-start mx-4"></span>
               <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                    <li class="breadcrumb-item text-muted">
                        <a href="{{ route('home') }}" class="text-muted text-hover-primary">Home</a>
                    </li>
                    <li class="breadcrumb-item"><span class="bullet bg-gray-200 w-5px h-2px"></span></li>
                    <li class="breadcrumb-item text-muted"><a href="{{route('clientes.index')}}" class="text-muted text-hover-primary">Listar Clientes</a></li>
                    <li class="breadcrumb-item"><span class="bullet bg-gray-200 w-5px h-2px"></span></li>
                    <li class="breadcrumb-item text-dark">{{$cliente->name}}</li>
                </ul>
            </div>
        </div>
    </div>
    <div class="post d-flex flex-column-fluid" id="kt_post">
        <div id="kt_content_container" class="container-xxl">
            @include('admin.clientes.base')

            <!--begin::Conteudo-->
            <div class="d-flex flex-wrap flex-stack mb-6">
                <h3 class="fw-bolder my-2">Resumo do perfil</h3>
            </div>

            <div class="row g-6 g-xl-9">
                <div class="col-sm-6 col-xl-4">
                    <div class="card h-100">
                        <div class="card-header flex-nowrap border-0 pt-9">
                            <div class="card-title m-0">
                                <div class="symbol symbol-45px w-45px bg-light me-5">
                                    <img src="{{url('adm')}}/assets/images/paw.png" class="p-3" />
                                </div>
                                <a href="#" class="fs-4 fw-bold text-hover-primary text-gray-600 m-0">Animais</a>
                            </div>
                            <div class="card-toolbar m-0">
                                <button type="button" class="btn btn-clean btn-sm btn-icon btn-icon-primary btn-active-light-primary me-n3" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
                                    <span class="svg-icon svg-icon-3 svg-icon-primary">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24">
                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                <rect x="5" y="5" width="5" height="5" rx="1" fill="#000000" />
                                                <rect x="14" y="5" width="5" height="5" rx="1" fill="#000000" opacity="0.3" />
                                                <rect x="5" y="14" width="5" height="5" rx="1" fill="#000000" opacity="0.3" />
                                                <rect x="14" y="14" width="5" height="5" rx="1" fill="#000000" opacity="0.3" />
                                            </g>
                                        </svg>
                                    </span>
                                </button>
                                <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-800 menu-state-bg-light-primary fw-bold w-200px py-3" data-kt-menu="true">
                                    <div class="menu-item px-3">
                                        <div class="menu-content text-muted pb-2 px-3 fs-7 text-uppercase">Menu</div>
                                    </div>
                                    <div class="menu-item px-3">
                                        <a href="#" class="menu-link px-3" data-bs-toggle="modal" data-bs-target="#novo_animal">Novo Animal </a>
                                    </div>
                                    <div class="menu-item px-3">
                                        <a href="{{route('cliente.animais',$cliente->id)}}" class="menu-link px-3">Listar Animais</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body d-flex flex-column px-9 pt-6 pb-8">
                            <div class="fs-2tx fw-bolder mb-3">{{$totalAnimais}}</div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-xl-4">
                    <div class="card h-100">
                        <div class="card-header flex-nowrap border-0 pt-9">
                            <div class="card-title m-0">
                                <div class="symbol symbol-45px w-45px bg-light me-5">
                                    <img src="{{url('adm')}}/assets/images/atendimentos.png" class="p-3" />
                                </div>
                                <a href="#" class="fs-4 fw-bold text-hover-primary text-gray-600 m-0">Atendimentos</a>
                            </div>
                            <div class="card-toolbar m-0">
                                <button type="button" class="btn btn-clean btn-sm btn-icon btn-icon-primary btn-active-light-primary me-n3" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
                                    <span class="svg-icon svg-icon-3 svg-icon-primary">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24">
                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                <rect x="5" y="5" width="5" height="5" rx="1" fill="#000000" />
                                                <rect x="14" y="5" width="5" height="5" rx="1" fill="#000000" opacity="0.3" />
                                                <rect x="5" y="14" width="5" height="5" rx="1" fill="#000000" opacity="0.3" />
                                                <rect x="14" y="14" width="5" height="5" rx="1" fill="#000000" opacity="0.3" />
                                            </g>
                                        </svg>
                                    </span>
                                </button>
                                <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-800 menu-state-bg-light-primary fw-bold w-200px py-3" data-kt-menu="true">
                                    <div class="menu-item px-3">
                                        <div class="menu-content text-muted pb-2 px-3 fs-7 text-uppercase">Menu</div>
                                    </div>
                                    <div class="menu-item px-3">
                                        <a href="#" class="menu-link px-3" data-bs-toggle="modal" data-bs-target="#novo_atendimento">Novo Atendimento </a>
                                    </div>
                                    <div class="menu-item px-3">
                                        <a href="#" class="menu-link px-3">Listar Atendimentos</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body d-flex flex-column px-9 pt-6 pb-8">
                            <div class="fs-2tx fw-bolder mb-3">{{$totalAtendimentos}}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--end::Post-->
</div>
<!--end::Content-->
<!--begin::Footer-->
    @endsection
@section('css')
    <link rel="shortcut icon" href="{{ url('adm') }}/assets/media/logos/favicon.ico" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
    <link href="{{ url('adm') }}/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet"
        type="text/css" />
    <link href="{{ url('adm') }}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
@endsection

@section('js')
    <script>
        $(document).ready(function() {
            $("#self").on("change", function() {
                document.getElementById("formSelf").submit();
            });
            Inputmask({
                "mask": "[9][.][9][.][9][.][9][9][9]KG"
            }).mask("#peso");
            Inputmask({
                "mask": "99/99/9999"
            }).mask("#nascimento");

            $("#especie").change(function() {
                const url = $("#personForm").attr("data-especie-url");
                especie = $(this).val();
                $.ajax({
                    url: url,
                    data: {
                        'especie': especie
                    },
                    success: function(data) {
                        $("#raca").html(data);
                    }
                });
            });
        });
    </script>
    <script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/scripts.bundle.js"></script>
    <!--begin::Page Vendors Javascript(used by this page)-->
    <script src="{{ url('adm') }}/assets/plugins/custom/datatables/datatables.bundle.js"></script>
    <!--end::Page Vendors Javascript-->
    <!--begin::Page Custom Javascript(used by this page)-->
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/table.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/export-users.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/add.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/widgets.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/chat/chat.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/create-app.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/upgrade-plan.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/intro.js"></script>
    <!--end::Page Custom Javascript-->
@endsection
