@extends('layouts.base')
@section('titulo', 'Histórico de Orçamentos')
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="toolbar" id="kt_toolbar">
            <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
                <div data-kt-swapper="true" data-kt-swapper-mode="prepend"
                    data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}"
                    class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                    <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">{{$cliente->name}}</h1>
                    <span class="h-20px border-gray-200 border-start mx-4"></span>
                    <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                        <li class="breadcrumb-item text-muted">
                            <a href="{{ route('home') }}" class="text-muted text-hover-primary">Home</a>
                        </li>
                        <li class="breadcrumb-item"><span class="bullet bg-gray-200 w-5px h-2px"></span></li>
                        <li class="breadcrumb-item text-muted"><a href="{{ route('clientes.index') }}"
                                class="text-muted text-hover-primary">Listar Clientes</a></li>
                        <li class="breadcrumb-item"><span class="bullet bg-gray-200 w-5px h-2px"></span></li>
                        <li class="breadcrumb-item text-dark">{{ $cliente->name }}</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-xxl">
                @include('admin.clientes.base')
                <div class="card">
                    <div class="card-body pt-0">
                        <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_subscriptions_table">
                            <thead>
                               <tr class="text-start text-muted fw-bolder fs-7 text-uppercase gs-0">
                                    <th class="w-10px pe-2"></th>
                                    <th class="min-w-125px">Data</th>
                                    <th class="min-w-125px">Valor</th>
                                    <th class="min-w-125px">Operador</th>
                                    <th class="text-end min-w-70px">Ações</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-600 fw-bold">
                                @foreach ($vendas as $venda)
                                <tr>
                                    <td>{{$venda->id}}</td>
                                    <td>{{date('d',strtotime($venda->created_at))}} de {{$mes[date('m',strtotime($venda->created_at))]}} de {{date('Y',strtotime($venda->created_at))}}</td>
                                    <td>R$ {{moeda($venda->total)}}</td>
                                    <td>{{!empty($venda->operador->name) ? $venda->operador->name : 'Não informado'}}</td>
                                    <td class="text-end">
                                        <a href="{{route('orcamento',$venda->id)}}" target="_blank" class="btn btn-light btn-active-light-primary btn-sm">
                                            <span class="svg-icon svg-icon-5 m-0">
                                                <i class="fas fa-eye"></i>
                                            </span>
                                            Visualizar
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <!--end::CONTEÚDO DINÂMICO-->
            </div>
        </div>
    </div>
@endsection
@section('css')
    <link rel="shortcut icon" href="{{ url('adm') }}/assets/media/logos/favicon.ico" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
    <link href="{{ url('adm') }}/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet"
        type="text/css" />
    <link href="{{ url('adm') }}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
@endsection

@section('js')

    <script>
        $(document).ready(function() {
            $("#self").on("change", function() {
                document.getElementById("formSelf").submit();
            });
            Inputmask({
                "mask": "[9][.][9][.][9][.][9][9][9]KG"
            }).mask("#peso");
            Inputmask({
                "mask": "99/99/9999"
            }).mask("#nascimento");

            $("#especie").change(function() {
                const url = $("#personForm").attr("data-especie-url");
                especie = $(this).val();
                $.ajax({
                    url: url,
                    data: {
                        'especie': especie
                    },
                    success: function(data) {
                        $("#raca").html(data);
                    }
                });
            });
        });
    </script>
    <script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/scripts.bundle.js"></script>
    <!--begin::Page Vendors Javascript(used by this page)-->
    <script src="{{ url('adm') }}/assets/plugins/custom/datatables/datatables.bundle.js"></script>
    <!--end::Page Vendors Javascript-->
    <!--begin::Page Custom Javascript(used by this page)-->
    <script src="{{ url('adm') }}/assets/js/custom/pages/projects/settings/settings.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/table.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/export-users.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/add.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/widgets.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/chat/chat.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/create-app.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/upgrade-plan.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/intro.js"></script>
    <!--end::Page Custom Javascript-->
@endsection
