@extends('layouts.base')
@section('titulo', 'Cadastro de Anúncios')
@section('content')
    @if (empty($anuncio->id))
        <meta http-equiv="refresh" content="0;url={{ route('anuncio.create') }}">
    @else
        <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
            <div class="toolbar" id="kt_toolbar">
                <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
                    <div data-kt-swapper="true" data-kt-swapper-mode="prepend"
                        data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}"
                        class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                        <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">Cadastro de Anúncios</h1>
                    </div>
                    <div class="d-flex align-items-center py-1">
                        <a href="{{ route('anuncio.duplicar',$anuncio->id) }}" class="btn btn-sm btn-danger">Duplicar Anúncios</a>
                        <a href="{{ route('todos.anuncios', 1) }}" class="btn btn-sm btn-primary">Listar Anúncios</a>
                    </div>
                </div>
            </div>
            <div class="post d-flex flex-column-fluid" id="kt_post">
                <div id="kt_content_container" class="container-xxl">
                    @if (session('message'))
                        <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                            <span class="svg-icon svg-icon-2hx svg-icon-danger me-4">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                    fill="none">
                                    <path opacity="0.3"
                                        d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z"
                                        fill="black"></path>
                                    <path
                                        d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z"
                                        fill="black"></path>
                                </svg>
                            </span>
                            <div class="d-flex flex-column">
                                <h4 class="mb-1 text-danger">{{ session('message') }}</h4>
                            </div>
                        </div>
                    @endif
                    @if (session('success'))
                        <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                            <span class="svg-icon svg-icon-2hx svg-icon-success me-4">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                    fill="none">
                                    <path opacity="0.3"
                                        d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z"
                                        fill="black"></path>
                                    <path
                                        d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z"
                                        fill="black"></path>
                                </svg>
                            </span>
                            <div class="d-flex flex-column">
                                <h4 class="mb-1 text-success">{{ session('success') }}</h4>
                            </div>
                        </div>
                    @endif
                    @if ($errors->any())
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 ">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-danger" role="alert">
                                    {{ $error }}
                                </div>
                            @endforeach
                        </div>
                    @endif
                    <div class="card mb-5 mb-xl-10">
                        <div class="card-header border-0 cursor-pointer">
                            <div class="card-title m-0">
                                <h3 class="fw-bolder m-0">Formulário de Cadastro</h3>
                            </div>
                            <a href="{{route('anuncio.destroy', $anuncio->id)}}" class="btn text-danger">Remover</a>
                        </div>
                        <div id="kt_account_settings_profile_details" class="collapse show">
                            <form enctype="multipart/form-data" method="POST" action="{{ route('anuncio.store') }}" id="" class="form fv-plugins-bootstrap5 fv-plugins-framework">
                                @csrf
                                <input type="hidden" value="{{ $anuncio->id }}" name="anuncio_id" id="anuncio_id">
                                <div class="card-body border-top p-9">

                                <div class="row mb-6">
                                    <label class="col-lg-4 col-form-label required fw-bold fs-6">Representante</label>
                                    <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                        <select type="text" name="representanteID" class="form-control form-control-lg form-control-solid">
                                        <option value="">Selecione um representante</option>
                                            @foreach ($representantes as $representante)
                                                <option value="{{ $representante->id }}" {{ $representante->id == $anuncio->representanteID ? 'selected' : '' }}>{{ $representante->nome }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="row mb-6">
                                    <label class="col-lg-4 col-form-label required fw-bold fs-6">Nº do Contrato</label>
                                    <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                        <input value="{{ $anuncio->contrato }}" type="text" name="contrato" class="form-control form-control-lg form-control-solid" placeholder="Nº do Contrato">
                                        <div class="fv-plugins-message-container invalid-feedback"></div>
                                    </div>
                                </div>
                                <div class="row mb-6">
                                    <label class="col-lg-4 col-form-label required fw-bold fs-6">CNPJ</label>
                                    <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                        <input value="{{ $anuncio->cnpj }}" type="text" name="cnpj" id="cnpj" class="form-control form-control-lg form-control-solid" placeholder="CNPJ">
                                        <div class="fv-plugins-message-container invalid-feedback"></div>
                                    </div>
                                </div>
                                <div id="result_empresa">
                                    <div class="row mb-6">
                                        <label class="col-lg-4 col-form-label required fw-bold fs-6">Nome Fantasia</label>
                                        <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                            <input value="{{ $anuncio->fantasia }}" type="text" name="fantasia" id="fantasia" class="form-control form-control-lg form-control-solid"  placeholder="Nome Fantasia">
                                            <div class="fv-plugins-message-container invalid-feedback"></div>
                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <label class="col-lg-4 col-form-label required fw-bold fs-6">Razão Social</label>
                                        <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                            <input value="{{ $anuncio->razao }}" type="text" name="razao" id="razao"
                                                class="form-control form-control-lg form-control-solid"
                                                placeholder="Razão Social">
                                            <div class="fv-plugins-message-container invalid-feedback"></div>
                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <label class="col-lg-4 col-form-label fw-bold fs-6">Endereço</label>
                                        <div class="col-lg-8">
                                            <div class="row">
                                                <div class="col-lg-4 fv-row fv-plugins-icon-container">
                                                    <input value="{{ $anuncio->cep }}" type="tel" name="cep" id="cep" laceholder="CEP"
                                                        class="form-control form-control-lg form-control-solid">
                                                    <div class="fv-plugins-message-container invalid-feedback"></div>
                                                </div>
                                                <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                                    <input value="{{ $anuncio->endereco }}" type="text" name="endereco" id="endereco"
                                                        value="{{ $anuncio->endereco }}" placeholder="Endereço"
                                                        class="form-control form-control-lg form-control-solid">
                                                    <div class="fv-plugins-message-container invalid-feedback"></div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-lg-4 fv-row fv-plugins-icon-container">
                                                    <input type="tel" name="numero" id="numero"
                                                        value="{{ $anuncio->numero }}" placeholder="Nº"
                                                        class="form-control form-control-lg form-control-solid">
                                                    <div class="fv-plugins-message-container invalid-feedback"></div>
                                                </div>
                                                <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                                    <input type="text" name="complemento" id="complemento"
                                                        value="{{ $anuncio->complemento }}" placeholder="Complemento"
                                                        class="form-control form-control-lg form-control-solid">
                                                    <div class="fv-plugins-message-container invalid-feedback"></div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-lg-4 fv-row fv-plugins-icon-container">
                                                    <input type="tel" name="bairro" id="bairro" value="{{ $anuncio->bairro }}" placeholder="Bairro"
                                                        class="form-control form-control-lg form-control-solid">
                                                    <div class="fv-plugins-message-container invalid-feedback"></div>
                                                </div>
                                                <div class="col-lg-4 fv-row fv-plugins-icon-container">
                                                    <input type="text" name="cidade" id="cidade"
                                                        value="{{ $anuncio->cidade }}" placeholder="Cidade"
                                                        class="form-control form-control-lg form-control-solid">
                                                    <div class="fv-plugins-message-container invalid-feedback"></div>
                                                </div>
                                                <div class="col-lg-4 fv-row fv-plugins-icon-container">
                                                    <select type="text" name="estado" id="estado"
                                                        class="form-control form-control-lg form-control-solid">
                                                        <option value="">Selecione um estado</option>
                                                        @foreach ($estados as $estado)
                                                            <option value="{{ $estado->nome }}" {{ $estado->nome == $anuncio->estado ? 'selected' : ''}}>{{ $estado->nome }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    <div class="fv-plugins-message-container invalid-feedback"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <label class="col-lg-4 col-form-label required fw-bold fs-6">E-mail</label>
                                        <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                            <input value="{{ $anuncio->email }}" type="email" name="email" id="email" placeholder="E-mail" class="form-control form-control-lg form-control-solid">
                                            <div class="fv-plugins-message-container invalid-feedback"></div>
                                        </div>
                                    </div>
                                    <label class="form-check form-check-custom form-check-solid">
                                        <input name="destaque" class="form-check-input" type="checkbox" value="1" />
                                        <span class="form-check-label text-gray-600">
                                            <div class="fv-plugins-message-container invalid-feedback">Destaque</div>
                                        </span>
                                    </label>
                                    <div class="row mb-6">
                                        <label class="col-lg-4 col-form-label fw-bold fs-6">Instagram</label>
                                        <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                            <input value="{{ $anuncio->instagram }}"type="text" name="instagram" id="instagram"
                                                class="form-control form-control-lg form-control-solid"
                                                placeholder="Instagram">
                                            <div class="fv-plugins-message-container invalid-feedback"></div>
                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <label class="col-lg-4 col-form-label fw-bold fs-6">Facebook</label>
                                        <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                            <input value="{{ $anuncio->facebook }}"type="text" name="facebook" id="facebook"
                                                class="form-control form-control-lg form-control-solid"
                                                placeholder="Facebook">
                                            <div class="fv-plugins-message-container invalid-feedback"></div>
                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <label class="col-lg-4 col-form-label fw-bold fs-6">Site</label>
                                        <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                            <input value="{{ $anuncio->site }}"type="text" name="site" id="site"
                                                class="form-control form-control-lg form-control-solid"
                                                placeholder="Site">
                                            <div class="fv-plugins-message-container invalid-feedback"></div>
                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <label class="col-lg-4 col-form-label fw-bold fs-6">Categorias</label>
                                        <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                            <select name="categoria_id" id="categoria_id" class="form-select"
                                                data-control="select2" data-placeholder="Selecione uma Categoria">
                                                <option></option>
                                                @foreach ($categorias as $categoria)
                                                    <option value="{{ $categoria->id }}" {{ $categoria->id == $anuncio->categoriaID ? 'selected' : '' }}>{{ $categoria->level1 }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <label class="col-lg-4 col-form-label fw-bold fs-6">Informações do Responsável</label>
                                        <div class="col-lg-8">
                                            <div class="row">
                                                <div class="col-lg-4 fv-row fv-plugins-icon-container">
                                                    <label class="col-form-label fw-bold fs-6">Titulo</label>
                                                    <select name="titulo" id="titulo"
                                                        class="form-control form-control-lg form-control-solid">
                                                        <option value="Ir.·.">Ir.·.</option>
                                                        <option value="Sobr.·.">Sobr.·.</option>
                                                        <option value="Cunh.·.">Cunh.·.</option>
                                                        <option value="V.·. M.·.">V.·. M.·.</option>
                                                        <option value="1º VIG.·.">1º VIG.·.</option>
                                                        <option value="2º VIG.·.">2º VIG.·.</option>
                                                        <option value="Sr.">Sr.</option>
                                                        <option value="Srª.">Srª.</option>
                                                        <option value="Dr.">Dr.</option>
                                                        <option value="Drª.">Drª.</option>
                                                    </select>
                                                </div>
                                                <div class="col-lg-8 fv-row fv-plugins-icon-container mb-10">
                                                    <label class="col-form-label fw-bold fs-6">Nome do Responsável</label>
                                                    <input type="text" name="nome" id="nome" class="form-control form-control-lg form-control-solid" placeholder="Nome do Responsável">
                                                </div>
                                                <div class="col-lg-4 fv-row fv-plugins-icon-container">
                                                    <label class="col-form-label fw-bold fs-6">CPF</label>
                                                    <input type="text" name="cpf" id="cpf" class="form-control form-control-lg form-control-solid" placeholder="CPF">
                                                </div>
                                                <div class="col-lg-4 fv-row fv-plugins-icon-container">
                                                    <label class="col-form-label fw-bold fs-6">Data de Nascimento</label>
                                                    <input type="text" name="nascimento" id="nascimento" class="form-control form-control-lg form-control-solid" placeholder="Data de Nascimento">
                                                </div>
                                                <div class="col-lg-2 fv-row fv-plugins-icon-container">
                                                    <label class="col-form-label fw-bold fs-6">Tipo Sanguíneo</label>
                                                    <select type="text" name="sangue" id="sangue" class="form-control">
                                                        <option value="N/I">N/I</option>
                                                        <option value="A+">A+</option>
                                                        <option value="B+">B+</option>
                                                        <option value="AB+">AB+</option>
                                                        <option value="O+">O+</option>
                                                        <option value="A-">A-</option>
                                                        <option value="B-">B-</option>
                                                        <option value="AB-">AB-</option>
                                                        <option value="O-">O-</option>
                                                    </select>
                                                </div>
                                                <div class="col-lg-2 fv-row fv-plugins-icon-container">
                                                    <button type="button" name="executar" class="btn" id="addSocio">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                                            <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="10" fill="black" />
                                                            <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="black" />
                                                            <rect x="6.01041" y="10.9247" width="12" height="2"  rx="1" fill="black" />
                                                        </svg>
                                                    </button>
                                                </div>
                                            </div>

                                            <div class="row mt-10">
                                                <div class="col-lg-12 fv-row fv-plugins-icon-container">
                                                    <table class="table table-row-bordered align-middle gy-4 gs-9">
                                                        <thead
                                                            class="border-bottom border-gray-200 fs-6 text-gray-600 fw-bolder bg-light bg-opacity-75">
                                                            <tr>
                                                                <td class="">Nome</td>
                                                                <td class="">CPF</td>
                                                                <td class="">Nasc</td>
                                                                <td class="">Tipo Sanguíneo</td>
                                                                <td class=""></td>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="fw-bold text-gray-600" id="listar_socios">
                                                            @foreach ($anuncio->Socios as $socio)
                                                                <tr id="socio{{ $socio->id }}">
                                                                    <td>{{ $socio->nome }}</td>
                                                                    <td>{{ $socio->cpf }}</td>
                                                                    <td>{{ $socio->nascimento }}</td>
                                                                    <td>{{ $socio->sangue }}</td>
                                                                    <td class="text-right">
                                                                        <button type="button" onclick="javascript:exSocio({{ $socio->id }})" class="btn btn-sm btn-danger btn-active-light-danger">Excluir</button>
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mb-20" style="margin-top: 50px;">
                                        <label class="col-lg-4 col-form-label fw-bold fs-6">Contatos</label>
                                        <div class="col-lg-8">
                                            <div class="row">
                                                <div class="col-lg-4 fv-row fv-plugins-icon-container">
                                                    <select type="text" id="tipo"
                                                        class="form-control form-control-lg form-control-solid">
                                                        <option value="Fixo">Fixo</option>
                                                        <option value="Celular">Celular</option>
                                                        <option value="Whatsapp">Whatsapp</option>
                                                    </select>
                                                </div>
                                                <div class="col-lg-4 fv-row fv-plugins-icon-container">
                                                    <input type="text" id="contato" placeholder="(XX)XXXXX-XXXX" class="form-control form-control-lg form-control-solid">
                                                </div>
                                                <div class="col-lg-2 fv-row fv-plugins-icon-container">
                                                    <button type="button" name="executar" class="btn" id="addTelefone">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                                            <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="10" fill="black" />
                                                            <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="black" />
                                                            <rect x="6.01041" y="10.9247" width="12" height="2"  rx="1" fill="black" />
                                                        </svg>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="row mt-10">
                                                <div class="col-lg-12 fv-row fv-plugins-icon-container">
                                                    <table class="table table-row-bordered align-middle gy-4 gs-9">
                                                        <thead
                                                            class="border-bottom border-gray-200 fs-6 text-gray-600 fw-bolder bg-light bg-opacity-75">
                                                            <tr>
                                                                <td class="min-w-150px">Tipo</td>
                                                                <td class="min-w-250px">Número</td>
                                                                <td class="min-w-150px">Ações</td>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="fw-bold text-gray-600" id="listar_telefones">
                                                            @foreach ($anuncio->telefones as $telefone)
                                                                <tr id="tel{{ $telefone->id }}">
                                                                    <td>{{ $telefone->tipo }}</td>
                                                                    <td>{{ formataTelefone($telefone->numero) }}</td>
                                                                    <td class="text-right">
                                                                        <button type="button"
                                                                            onclick="javascript:exTel({{ $telefone->id }})"
                                                                            class="btn btn-sm btn-danger btn-active-light-danger">Excluir</button>
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <label class="col-lg-4 col-form-label required fw-bold fs-6">Potência</label>
                                        <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                            <select type="text" name="potencia" class="form-control form-control-lg form-control-solid">
                                            <option value="">Selecione uma potência</option>
                                                @foreach ($potencias as $potencia)
                                                    <option value="{{ $potencia->estadual }}">{{ $potencia->estadual }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <label class="col-lg-4 col-form-label required fw-bold fs-6">Loja</label>
                                        <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                            <input value="{{ $anuncio->loja }}" type="text" name="loja" class="form-control form-control-lg form-control-solid"  placeholder="Loja">
                                            <div class="fv-plugins-message-container invalid-feedback"></div>
                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <label class="col-lg-4 col-form-label required fw-bold fs-6">Nº Loja</label>
                                        <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                            <input value="{{ $anuncio->numero_loja }}" type="text" name="numero_loja" class="form-control form-control-lg form-control-solid"  placeholder="Nº Loja">
                                            <div class="fv-plugins-message-container invalid-feedback"></div>
                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <label class="col-lg-4 col-form-label required fw-bold fs-6">Palavras Chaves separados por (,)</label>
                                        <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                            <input value="{{ $anuncio->palavras }}" type="text" name="palavras" class="form-control form-control-lg form-control-solid"  placeholder="Ex.: Criação de sites, criação de aplicativos">
                                            <div class="fv-plugins-message-container invalid-feedback"></div>
                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <label class="col-lg-4 col-form-label fw-bold fs-6">Imagem</label>
                                        <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                            <input type="file" name="thumb" id="thumb"  class="form-control form-control-lg form-control-solid">
                                            <br><br>
                                            <img src="{{ $anuncio->thumb }}" width="200">
                                        </div>
                                    </div>
                                    <div class="row mb-6">
                                        <label class="col-lg-4 col-form-label fw-bold fs-6">Slide</label>
                                        <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                            <input type="file" name="slide" id="slide"  class="form-control form-control-lg form-control-solid">
                                            <br><br>
                                            <img src="{{ $anuncio->slide }}" width="200">
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer d-flex justify-content-end py-6 px-9">
                                    <button type="submit" name="executar" class="btn btn-primary"  id="kt_account_profile_details_submit">Atualizar</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection
@section('css')
    <link href="{{ url('adm') }}/assets/plugins/custom/fullcalendar/fullcalendar.bundle.css" rel="stylesheet"
        type="text/css" />
    <link href="{{ url('adm') }}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
@endsection

@section('js')
    <script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/scripts.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/account/settings/deactivate-account.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/two-factor-authentication.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/widgets.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/chat/chat.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/create-app.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/upgrade-plan.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/intro.js"></script>

    <script>
        Inputmask({
            "mask": "(99) 99999-9999"
        }).mask("#contato");
        Inputmask({
            "mask": "99999-999"
        }).mask("#cep");
        Inputmask({
            "mask": "99.999.999/9999-99"
        }).mask("#cnpj");
        Inputmask({
            "mask": "999.999.999-99"
        }).mask("#cpf");
        Inputmask({
            "mask": "99/99/9999"
        }).mask("#nascimento");
    </script>

    <script>
        $(document).ready(function() {

            $("#cnpj").on("blur", function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "{{ route('consulta.cnpj') }}",
                    method: 'POST',
                    data: {
                        cnpj: $("#cnpj").val(),
                    },
                    success: function(result) {
                        $("#result_empresa").html(result);
                    }
                });
            });


            $("#cliente_id").change(function() {
                if ($("#cliente_id").val() == 'new') {
                    $("#responsavel").show();
                }
            });
            $("#categoria_id").change(function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "{{ route('get.categorias') }}",
                    method: 'POST',
                    data: {
                        categoria_id: $("#categoria_id").val()
                    },
                    success: function(result) {
                        $("#sub_categoria_id").html(result);
                    }
                });
            });

            $("#addSocio").on("click", function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "{{ route('add.socio') }}",
                    method: 'POST',
                    data: {
                        id: $("#anuncio_id").val(),
                        titulo: $("#titulo").val(),
                        nome: $("#nome").val(),
                        cpf: $("#cpf").val(),
                        nascimento: $("#nascimento").val(),
                        sangue: $("#sangue").val(),
                    },
                    success: function(result) {
                        $("#listar_socios").html(result);
                    }
                });
            });

            $("#addTelefone").on("click", function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "{{ route('add.telefone') }}",
                    method: 'POST',
                    data: {
                        id: $("#anuncio_id").val(),
                        tipo: $("#tipo").val(),
                        numero: $("#contato").val()
                    },
                    success: function(result) {
                        $("#listar_telefones").html(result);
                    }
                });
            });

            $("#cep").on("blur", function() {
                var numCep = $("#cep").val();
                var url = "https://viacep.com.br/ws/" + numCep + "/json";
                $.ajax({
                    url: url,
                    type: "get",
                    dataType: "json",
                    success: function(dados) {
                        console.log(dados);
                        $("#cep").val(dados.cep);
                        $("#endereco").val(dados.logradouro);
                        $("#bairro").val(dados.bairro);
                        $("#cidade").val(dados.localidade);
                        $("#estado").val(dados.uf);
                    }
                })
            });
        });

        function exTel(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('remove.telefone') }}",
                method: 'POST',
                data: {
                    id: id,
                },
                success: function(result) {
                    $("#tel" + id).hide();
                }
            });
        }

        function exSocio(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('remove.socio') }}",
                method: 'POST',
                data: {
                    id: id,
                },
                success: function(result) {
                    $("#socio" + id).hide();
                }
            });
        }
    </script>

@endsection
