@extends('layouts.base')
@section('titulo', 'Cadastro de Anúncios')
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="toolbar" id="kt_toolbar">
            <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
                <div data-kt-swapper="true" data-kt-swapper-mode="prepend"
                    data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}"
                    class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                    <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">Anúncios Cadastradas</h1>
                    <span class="h-20px border-gray-200 border-start mx-4"></span>
                    <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                        <li class="breadcrumb-item text-muted">
                            <a href="{{ route('admin.home') }}" class="text-muted text-hover-primary">Home</a>
                        </li>
                        <li class="breadcrumb-item">
                            <span class="bullet bg-gray-200 w-5px h-2px"></span>
                        </li>
                        <li class="breadcrumb-item text-dark"></li>
                    </ul>
                </div>
                <div class="d-flex align-items-center py-1">
                    <div class="me-4">
                        <a href="#" class="btn btn-sm btn-flex btn-light btn-active-primary fw-bolder"
                            data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
                            <span class="svg-icon svg-icon-5 svg-icon-gray-500 me-1">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                    fill="none">
                                    <path
                                        d="M19.0759 3H4.72777C3.95892 3 3.47768 3.83148 3.86067 4.49814L8.56967 12.6949C9.17923 13.7559 9.5 14.9582 9.5 16.1819V19.5072C9.5 20.2189 10.2223 20.7028 10.8805 20.432L13.8805 19.1977C14.2553 19.0435 14.5 18.6783 14.5 18.273V13.8372C14.5 12.8089 14.8171 11.8056 15.408 10.964L19.8943 4.57465C20.3596 3.912 19.8856 3 19.0759 3Z"
                                        fill="black" />
                                </svg>
                            </span>Filtrar</a>
                        <div class="menu menu-sub menu-sub-dropdown w-250px w-md-300px" data-kt-menu="true"
                            id="kt_menu_61b21adbd189f">
                            <div class="px-7 py-5">
                                <div class="fs-5 text-dark fw-bolder">Opções de Filtragem</div>
                            </div>
                            <div class="separator border-gray-200"></div>
                            <div class="px-7 py-5">
                                <div class="mb-10">
                                    <label class="form-label fw-bold">Status:</label>
                                    <div>
                                        <select class="form-select form-select-solid" data-kt-select2="true"
                                            data-placeholder="Select option" data-dropdown-parent="#kt_menu_61b21adbd189f"
                                            data-allow-clear="true">
                                            <option></option>
                                            <option value="1">Ativos</option>
                                            <option value="2">Inativos</option>
                                            <option value="2">Inadimplentes</option>
                                            <option value="2">Aguardando Aprovação</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-end">
                                    <button type="submit" class="btn btn-sm btn-primary"
                                        data-kt-menu-dismiss="true">Listar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <a href="{{ route('anuncio.create') }}" class="btn btn-sm btn-primary">Novo Anúncio</a>
                </div>
            </div>
        </div>
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-xxl">
                <div class="card">
                    <div class="card-header border-0 pt-6">
                        <div class="card-title">
                            <div class="d-flex align-items-center position-relative my-1">
                                <span class="svg-icon svg-icon-1 position-absolute ms-6">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" fill="none">
                                        <rect opacity="0.5" x="17.0365" y="15.1223" width="8.15546" height="2"
                                            rx="1" transform="rotate(45 17.0365 15.1223)" fill="black" />
                                        <path
                                            d="M11 19C6.55556 19 3 15.4444 3 11C3 6.55556 6.55556 3 11 3C15.4444 3 19 6.55556 19 11C19 15.4444 15.4444 19 11 19ZM11 5C7.53333 5 5 7.53333 5 11C5 14.4667 7.53333 17 11 17C14.4667 17 17 14.4667 17 11C17 7.53333 14.4667 5 11 5Z"
                                            fill="black" />
                                    </svg>
                                </span>
                                <form action="{{ route('buscar') }}" method="post">
                                    @csrf
                                    <input type="text" name="s" class="form-control form-control-solid w-250px ps-14" placeholder="Busca rápida" />
                                </form>
                            </div>
                        </div>
                        <div class="card-toolbar">
                            <div class="d-flex justify-content-end align-items-center d-none"
                                data-kt-user-table-toolbar="selected">
                                <div class="fw-bolder me-5">
                                    <span class="me-2" data-kt-user-table-select="selected_count"></span>Selected
                                </div>
                                <button type="button" class="btn btn-danger"
                                    data-kt-user-table-select="delete_selected">Delete Selected</button>
                            </div>
                        </div>
                    </div>
                    <div class="card-body pt-0">
                        <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_table_users">
                            <thead>
                                <tr class="text-start text-muted fw-bolder fs-7 text-uppercase gs-0">
                                    <th class="w-10px pe-2">
                                        <div class="form-check form-check-sm form-check-custom form-check-solid me-3">
                                            <input class="form-check-input" type="checkbox" data-kt-check="true"
                                                data-kt-check-target="#kt_table_users .form-check-input" value="1" />
                                        </div>
                                    </th>
                                    <th class="min-w-125px">Anúncio</th>
                                    <th class="min-w-125px">Categoria</th>
                                    <th class="min-w-125px">Nº Contrato</th>
                                    <th class="min-w-125px">Cidade-UF</th>
                                    <th class="min-w-125px">Telefone</th>
                                    <th class="min-w-125px">Visitas</th>
                                    <th class="text-end min-w-100px">Ações</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-600 fw-bold">
                                @if ($mostar = 1)
                                    @foreach ($anuncios as $anuncio)
                                        <tr>
                                            <td>
                                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                                    <input class="form-check-input" type="checkbox" value="1" />
                                                </div>
                                            </td>
                                            <td class="d-flex align-items-center">
                                                <div class="symbol symbol-circle symbol-50px overflow-hidden me-3">
                                                    <a href="{{ route('anuncio.show', $anuncio->id) }}">
                                                        <div class="symbol-label">
                                                            <img src="{{ !empty($anuncio->thumb) ? $anuncio->thumb : url('adm/assets/images/add-photo.png') }}" class="w-100" />
                                                        </div>
                                                    </a>
                                                </div>
                                                <div class="d-flex flex-column">
                                                    <a href="{{ route('anuncio.show', $anuncio->id) }}" class="text-gray-800 text-hover-primary mb-1">{{ $anuncio->fantasia }}</a>
                                                    <span>{{ $anuncio->nome }}</span>
                                                </div>
                                            </td>
                                            <td>{{ $anuncio->contrato }}</td>
                                            <td>{{ !empty($anuncio->categoria) ? $anuncio->categoria : 'Sem categoria' }}</td>
                                            <td>{{ $anuncio->cidade }}-{{ $anuncio->estado }}</td>
                                            <td>
                                                @if (!empty($anuncio->telefones))
                                                    @foreach ($anuncio->telefones as $telefone)
                                                        {{ formataTelefone($telefone->numero) }}
                                                    @endforeach
                                                @endif
                                            </td>
                                            <td>{{ $anuncio->visitas }}</td>
                                            <td class="text-end">
                                                <a href="{{ route('anuncio.show', $anuncio->id) }}"
                                                    class="btn btn-primary btn-active-primary btn-sm"
                                                    data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
                                                    Gerenciar
                                                </a>
                                                <a href="{{ route('anuncio.show', $anuncio->id) }}" class="btn btn-primary btn-active-primary btn-sm">
                                                   Migrar Categoria
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('css')
    <link rel="shortcut icon" href="{{ url('adm') }}/assets/media/logos/favicon.ico" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
    <link href="{{ url('adm') }}/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet"
        type="text/css" />
    <link href="{{ url('adm') }}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
@endsection

@section('js')

    <script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/scripts.bundle.js"></script>
    <!--begin::Page Vendors Javascript(used by this page)-->
    <script src="{{ url('adm') }}/assets/plugins/custom/datatables/datatables.bundle.js"></script>
    <!--end::Page Vendors Javascript-->
    <!--begin::Page Custom Javascript(used by this page)-->
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/table.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/export-users.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/add.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/widgets.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/chat/chat.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/create-app.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/upgrade-plan.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/intro.js"></script>
    <!--end::Page Custom Javascript-->
@endsection
