<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Anuncio extends Model
{
    use HasFactory;

    protected $fillable = [
        "id",
        "marketing",
        "status",
        "anuncioID",
        "userID",
        "data_cadastro",
        "cnpj",
        "razao",
        "fantasia",
        "representanteID",
        "representante",
        "contrato",
        "vencimento",
        "categoriaID",
        "categoria",
        "keywords",
        "endereco",
        "complemento",
        "numero",
        "bairro",
        "cidade",
        "estado",
        "url",
        "visitas",
        "click_telefone",
        "qtd_share",
        "destaque",
        "email",
        "email2",
        "site",
        "facebook",
        "instagram",
        "faternal",
        "tel0800",
        "cep",
        "thumb",
        "titulo_ir",
        "nome",
        "cpf",
        "nascimento",
        "lojaID",
        "loja",
        "numero_loja",
        "sangue",
        "potencia",
        "created_at",
        "updated_at",
        "level1_id",
        "level1",
        "level2_id",
        "level2",
        "nova_categoria",
        "slide",
    ];


    public function Socios()
    {
        return $this->hasMany(AnuncioPessoas::class, 'anuncioID', 'id');
    }
    public function representante()
    {
        return $this->hasOne("App\Models\User", 'id', 'representante_id');
    }
    public function categoria()
    {
        return $this->hasOne(Categoria::class, 'id', 'categoriaID');
    }
    public function sub()
    {
        return $this->hasOne("App\Models\SubCategoria", 'id', 'sub_categoria_id');
    }
    public function telefones()
    {
        return $this->hasMany(AnuncioTelefone::class, 'anuncioID', 'id');
    }
    public function setEstado()
    {
        return $this->hasOne("App\Models\Estado", 'uf', 'estado');
    }
    public function favorito()
    {
        return $this->hasOne("App\Models\Favorito", 'anuncio_id', 'id');
    }
    public function Whatsapp()
    {
        return $this->hasOne(AnuncioTelefone::class, 'anuncioID', 'id')->where('tipo','Whatsapp');
    }
}
