<?php

namespace App\Http\Controllers;

use App\Models\TrabalhoMaconico as ModelsTrabalhoMaconico;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;

class TrabalhoMaconico extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $exe = ModelsTrabalhoMaconico::get();
        return view('admin.trabalhos.index', compact('exe'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        $dados = $request->all();


        if ($request->arquivo) {
            $nameFile           = Str::of($request->titulo)->slug('-') . rand() . '.' . $request->arquivo->getClientOriginalExtension();
            $dados['arquivo']   = $request->arquivo->storeAs('trabalhos-maconicos', $nameFile);
        }
        $dados['ano'] = '2024';
        ModelsTrabalhoMaconico::create($dados);
        return redirect()->back()->with('success', 'Trabalho foi cadastrado com sucesso');
    }


    public function destroy($id)
    {
        $exe = ModelsTrabalhoMaconico::find($id);
        if (Storage::disk('local')->exists($exe->arquivo)) {
            Storage::disk('local')->delete($exe->arquivo);
        }
        $exe->delete();
        return redirect()->back()->with('success', 'Trabalho foi cadastrado com sucesso');
    }
}
