<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use GuzzleHttp\Client;

class PushController extends Controller
{

    private $accessToken;

    public function __construct()
    {
        $this->accessToken = env('EXPO_ACCESS_TOKEN'); // Pegue o token do .env
    }

    public function sendNotification(Request $request)
    {
        // Valide os parâmetros recebidos
        $validatedData = $request->validate([
            'expoPushToken' => 'required|string',
            'title' => 'required|string',
            'body' => 'required|string',
            'data' => 'nullable|array',
        ]);

        $expoPushToken = $validatedData['expoPushToken'];
        $title = $validatedData['title'];
        $body = $validatedData['body'];
        $data = $validatedData['data'] ?? [];

        $client = new Client();
        $url = 'https://exp.host/--/api/v2/push/send';
        $headers = [
            'Accept' => 'application/json',
            'Content-Type' => 'application/json',
            'Authorization' => 'Bearer ' . $this->accessToken,
        ];

        $payload = [
            'to' => $expoPushToken,
            'sound' => 'default',
            'title' => $title,
            'body' => $body,
            'data' => $data,
        ];

        try {
            $response = $client->post($url, [
                'headers' => $headers,
                'json' => $payload,
            ]);

            $result = json_decode($response->getBody(), true);
            return response()->json(['success' => true, 'result' => $result]);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'error' => $e->getMessage()], 500);
        }
    }
}
