<?php

namespace App\Http\Controllers\Aplicativo;

use App\Http\Controllers\Controller;
use App\Models\Anuncio;
use App\Models\Favorito;
use App\Models\Loja;
use App\Models\Potencia;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AppUserController extends Controller
{
    public function perfil()
    {
        $anuncios   = Anuncio::where('cliente_id',Auth::user()->id)->get();
        $favoritos  = Favorito::where('user_id',Auth::user()->id)->get();
        $potencias  = Potencia::orderby('estadual','ASC')->get();
        $lojas  = [];
        if(!empty(Auth::user()->potencia_id)){
            $lojas       = Loja::find(Auth::user()->potencia_id)->orderby('numero','ASC')->get();
        }

        $status = [
            '1' => 'Publicado',
            '2' => 'Em análise',
            '3' => 'Bloqueado',
            '10' => 'Rascunho',
        ];
        $cor = [
            '1' => 'success',
            '2' => 'warning',
            '3' => 'danger',
            '10' => 'info',
        ];
        // dd(Auth::user());
        return view('app.perfil',compact('anuncios','favoritos','potencias','lojas'),['status'=>$status,'cor'=>$cor,'estado'=>Auth::user()->estado,'cidade'=>Auth::user()->cidade]);
    }
}
