<?php

namespace App\Http\Controllers\Aplicativo;

use App\Http\Controllers\Controller;
use App\Models\Anuncio;
use App\Models\Categoria;
use App\Models\Estado;
use App\Models\Evento;
use App\Models\Loja;
use App\Models\Perguntas;
use App\Models\Potencia;
use App\Models\SubCategoria;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AppController extends Controller
{
    public function index()
    {
        return redirect()->route('admin.home');
        // $anuncios = Anuncio::where('status',1)->get();
        // foreach($anuncios as $anuncio){
        //     $dds = Anuncio::find($anuncio->id);
        //     $dados['level1'] = $dds->categoria->titulo;
        //     $dados['level2'] = !empty($dds->sub_categoria_id) ? $dds->sub->titulo : '';
        //     // dd($dados);
        //     $dds->update($dados);
        // }


        // if (!empty(Auth::user()->id) && Auth::user()->nivel == '1') {
        //     return redirect()->route('admin.home');
        // } else {
        //     $anuncios_destaque   = Anuncio::where('destaque', '1')->where('thumb', '!=', '')->get();
        //     $anuncios           = Anuncio::where('status', '1')->where('thumb', '!=', '')->limit(20)->inRandomOrder()->get();
        //     $free               = Anuncio::where('status', '1')->where('thumb', '=', '')->get();
        //     $categorias         = Anuncio::where('status', '1')->where('categoria_id','!=','')->groupby('categoria_id')->orderby('level1','ASC')->get();
        //     $todas_categorias   = Categoria::orderby('titulo', 'ASC')->get();

        //     $estados            = Anuncio::where('estado','!=','')->where('status',1)->groupby('estado')->orderby('estado','ASC')->get();
        //     $banners            = Anuncio::where('banner','!=','')->get();
        //     // dd($banners);
        //     $active = 'index';
        //     return view('app.index', compact('categorias', 'anuncios', 'free', 'anuncios_destaque', 'todas_categorias','estados','banners'),['active'=>$active]);
        // }
    }

    public function getCidades(Request $request)
    {
        $cidades = Anuncio::where('estado',$request->estado)->where('cidade','!=','')->where('status',1)->groupby('cidade')->orderby('cidade','ASC')->get();
        return view('app.ajax.getCidades', compact('cidades'));
    }


    public function home($estado, $cidade)
    {
        $estados    = Anuncio::where('estado','!=','')->where('status',1)->groupby('estado')->orderby('estado','ASC')->get();

        $sql = Anuncio::query();
        $sql2 = Anuncio::query();
        if ($estado != '0') {
            $sql->where('estado',$estado);
            $sql2->where('estado',$estado);
        }
        if ($cidade != '0') {
            $sql->where('cidade',$cidade);
            $sql2->where('cidade',$cidade);
        }
        $categorias = $sql->where('status', '1')->groupby('level1')->orderby('level1','ASC')->get();
        $anuncios   = $sql2->where('status', '1')->where('thumb', '!=', '')->orderby('empresa','ASC')->limit(20)->get();
        $banners    = Anuncio::where('banner','!=','')->get();
        $active     = 'home';
        // dd($estado,$cidade);
        return view('app.home',compact('estados','categorias','anuncios','banners'),['active'=>$active,'estado'=>$estado,'cidade'=>$cidade]);
    }

    public function fundadores()
    {
        $fundadores = User::where('fundador', '1')->get();
        // dd($fundadores);
        $todas_categorias = Categoria::orderby('titulo', 'ASC')->get();
        return view('app.fundadores', compact('todas_categorias', 'fundadores'));
    }

    public function PotenciaEstados()
    {
        $estados = Estado::orderby('nome', 'ASC')->get();
        $active = 'index';
        return view('app.potencias-estados', compact('estados'),['active'=>$active]);
    }

    public function potencias($estado)
    {
        $exe = Estado::where('uf', $estado)->first();
        $potencias = Potencia::where('estado', $exe->nome)->get();
        $active = 'index';
        return view('app.potencias', compact('potencias'), ['exe' => $exe,'active'=>$active]);
    }

    public function LojasCidades($potencia)
    {
        $pot        = Potencia::find($potencia);
        $cidades    = Loja::where('potencia_id', $potencia)->groupby('oriente')->where('oriente', '!=', '')->get();
        $active = 'index';
        // dd($cidades);
        return view('app.lojas-cidades', compact('cidades'), ['pot' => $pot,'active'=>$active]);
    }

    public function lojas($oriente, $potencia)
    {
        $pot        = Potencia::find($potencia);
        $cidade     = $oriente;
        $lojas      = Loja::where('oriente', $oriente)->where('potencia_id', $potencia)->get();
        $active = 'index';
        return view('app.lojas', compact('lojas'), ['pot' => $pot, 'cidade' => $cidade,'active'=>$active]);
    }

    public function loja($id)
    {
        $loja = Loja::find($id);
        $ico = [
            'Celular' => 'phone-portrait-outline',
            'Fixo' => 'call-outline',
            'Whatsapp' => 'logo-whatsapp',
        ];
        $active = 'index';
        return view('app.loja', ['loja' => $loja, 'ico' => $ico,'active'=>$active]);
    }

    public function eventos()
    {
        $eventos = Evento::orderby('id', 'DESC')->get();
        $active = 'index';
        return view('app.eventos', compact('eventos'),['active'=>$active]);
    }

    public function evento($id)
    {
        $evento = Evento::find($id);
        $active = 'index';
        return view('app.evento', ['evento' => $evento,'active'=>$active]);
    }

    public function quemsomos()
    {
        $active = 'index';
        return view('app.quem-somos',['active'=>$active]);
    }

    public function perguntas()
    {
        $perguntas = Perguntas::get();
        $active = 'index';
        return view('app.perguntas-frequentes', compact('perguntas'),['active'=>$active]);
    }

    public function categorias($estado, $cidade)
    {
        $sql = Anuncio::query();
        $sql2 = Anuncio::query();
        if ($estado != '0') {
            $sql->where('estado',$estado);
            $sql2->where('estado',$estado);
        }
        if ($cidade != '0') {
            $sql->where('cidade',$cidade);
            $sql2->where('cidade',$cidade);
        }
        $categorias = $sql->where('status', '1')->orderby('level1','ASC')->groupby('level1')->get();
        $estados    = Anuncio::where('estado','!=','')->where('status','1')->groupby('estado')->orderby('estado','ASC')->get();

        return view('app.categorias', compact('categorias','estados'),['estado'=>$estado,'cidade'=>$cidade]);
    }

    public function categoria($id, $estado, $cidade)
    {
        $categoria  = Categoria::find($id);
        $sql        = Anuncio::query();
        $sql2       = Anuncio::query();
        $exe_level2         = Anuncio::query();

        if ($estado != '0') {
            $sql->where('estado',$estado);
            $sql2->where('estado',$estado);
            $exe_level2->where('estado',$estado);
        }
        if ($cidade != '0') {
            $sql->where('cidade',$cidade);
            $sql2->where('cidade',$cidade);
            $exe_level2->where('cidade',$cidade);
        }

        $anuncios   = $sql->where('categoria_id', $id)->where('status', '1')->where('thumb', '!=', '')->orderby('empresa','ASC')->get();
        $free       = $sql2->where('categoria_id', $id)->where('status', '1')->where('thumb','')->orderby('empresa','ASC')->get();
        $estados    = Anuncio::where('estado','!=','')->where('status','1')->groupby('estado')->orderby('estado','ASC')->get();
        $level2     = $exe_level2->where('categoria_id', $id)->where('status','1')->where('sub_categoria_id','!=','')->groupby('sub_categoria_id')->orderby('sub_categoria_id', 'ASC')->get();

        // dd($level2);

        return view('app.anuncios', compact('anuncios', 'free','estados','level2'), ['categoria' => $categoria,'estado'=>$estado,'cidade'=>$cidade]);

    }


    public function CategoriaLevel2($level1_id, $level2_id,$estado,$cidade)
    {
        $dds_level2 = SubCategoria::find($level2_id);

        $sql        = Anuncio::query();
        $exe_level2 = Anuncio::query();
        if ($estado != '0') {
            $sql->where('estado', $estado);
            $exe_level2->where('estado', $estado);
        }
        if ($cidade != '0') {
            $sql->where('cidade', $cidade);
            $exe_level2->where('cidade', $cidade);
        }
        $anuncios       = $sql->where('categoria_id',$level1_id)->where('sub_categoria_id',$level2_id)->where('status',1)->get();

        $level2         = $exe_level2->where('categoria_id', $level1_id)->where('status','1')->where('sub_categoria_id','!=','')->groupby('sub_categoria_id')->orderby('sub_categoria_id', 'ASC')->get();
        $active         = '';
        // dd($anuncios);
        return view('app.categorias-level2', compact('anuncios','level2'), ['estado' => $estado, 'cidade' => $cidade, 'active' => $active]);
    }

    public function contato()
    {
        $active = 'index';
        return view('app.contato',['active'=>$active]);
    }

    public function busca(Request $request)
    {
        $sql_level1 = Anuncio::query();
        $sql_qtd_level1 = Anuncio::query();
        $sql_level2 = Anuncio::query();
        $sql_qtd_level2 = Anuncio::query();
        $sql        = Anuncio::query();

        if ($request->estado != '0') {
            $sql_qtd_level1->where('estado', $request->estado);
            $sql_qtd_level2->where('estado', $request->estado);
            $sql_level1->where('estado', $request->estado);
            $sql_level2->where('estado', $request->estado);
            $sql->where('estado', $request->estado);
        }

        if ($request->cidade != '0') {
            $sql_qtd_level1->where('cidade', $request->cidade);
            $sql_qtd_level2->where('cidade', $request->cidade);
            $sql_level1->where('cidade', $request->cidade);
            $sql_level2->where('cidade', $request->cidade);
            $sql->where('cidade', $request->cidade);
        }

        $level1     = $sql_level1->where('level1','LIKE','%'.$request->s.'%')->where('status',1)->groupby('level1')->get();
        $qtd_level1 = $sql_qtd_level1->where('level1','LIKE','%'.$request->s.'%')->where('status',1)->get();
        $level2     = $sql_level2->where('level2','LIKE','%'.$request->s.'%')->groupby('level2')->where('status',1)->get();
        $qtd_level2 = $sql_qtd_level2->where('level2','LIKE','%'.$request->s.'%')->where('status',1)->get();
        $anuncios   = $sql->where('empresa','LIKE','%'.$request->s.'%')->orwhere('level1','LIKE','%'.$request->s.'%')->orwhere('level2','LIKE','%'.$request->s.'%')->where('status',1)->get();

        return view('app.ajax.busca-rapida',compact('level1','qtd_level1','level2','qtd_level2','anuncios'),['cidade'=> $request->cidade, 'estado'=> $request->estado]);
    }

    public function GetLojas(Request $request)
    {
        $lojas  = Loja::where('potencia_id',$request->potencia_id)->orderby('numero','ASC')->get();
        return view('app.ajax.lojas',compact('lojas'));
    }

    public function trolhamento(Request $request)
    {
        $palavra = strtolower($request->sm);
        if($palavra == 'mictmr'){
            return redirect()->route('register');
        }else{
            return redirect()->back()->with('error','Resposta errada');
        }

    }

}
