<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Categoria;
use App\Models\SubCategoria;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SubCategoriaController extends Controller
{

    public function index($id)
    {
        $categoria = Categoria::find($id);
        $subs       = SubCategoria::where('categoria_id',$id)->get();
        return view('admin.subcategorias.index', compact('subs'),['categoria'=>$categoria]);
    }


    public function create()
    {

    }

    public function store(Request $request)
    {
        // dd($request->all());
        $dados              = $request->all();
        $dados['url']       = Str::of($request->titulo)->slug('-');
        SubCategoria::create($dados);
        return redirect()->back()->with('success', 'Sub-Categoria cadastrada com sucesso');
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        $categoria = SubCategoria::find($id);
        if(!$categoria){
            return redirect()->back();
        }

        $dados              = $request->all();
        $dados['url']       = Str::of($request->titulo)->slug('-');
        $categoria->update($dados);
        return redirect()->back()->with('success', 'Categoria atualizada com sucesso');
    }


    public function destroy($id)
    {
        //
    }
}
