<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Perguntas;
use Illuminate\Http\Request;

class PerguntasController extends Controller
{

    public function index()
    {
       $perguntas = Perguntas::get();
       return view('admin.perguntas-frequentes.index',compact('perguntas'));
    }


    public function create()
    {
       return view('admin.perguntas-frequentes.create');
    }


    public function store(Request $request)
    {
        Perguntas::create($request->all());
        return redirect()->back()->with('success','Cadastrado com sucesso!');
    }


    public function show($id)
    {
       $pergunta = Perguntas::find($id);
       return view('admin.perguntas-frequentes.show',['pergunta'=>$pergunta]);
    }



    public function update(Request $request, $id)
    {
        $pergunta = Perguntas::find($id);
        $pergunta->update($request->all());
        return redirect()->back()->with('success','Atualizado com sucesso!');
    }


    public function destroy($id)
    {
        $pergunta = Perguntas::find($id);
        $pergunta->delete();
        return redirect()->route('perguntas.index');
    }
}
