<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Evento;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class EventoController extends Controller
{

    public function index()
    {
        $eventos = Evento::get();
        return view('admin.eventos.index',compact('eventos'));
    }


    public function create()
    {
        return view('admin.eventos.create');
    }

    public function store(Request $request)
    {
        $dados              = $request->all();
        $nameFile           = Str::of($request->titulo)->slug('-') . rand() . '.' . $request->image->getClientOriginalExtension();
        $dados['image']     = $request->image->storeAs('eventos', $nameFile);
        $dados['url']       = Str::of($request->titulo)->slug('-');
        Evento::create($dados);

        return redirect()->back()->with('success', 'Evento publicado com successo');
    }


    public function show($id)
    {
        $evento = Evento::find($id);
        return view('admin.eventos.show',['evento'=>$evento]);
    }

    public function update(Request $request, $id)
    {
        $evento = Evento::find($id);
        $dados              = $request->all();
        if($request->image){
            $nameFile           = Str::of($request->titulo)->slug('-') . rand() . '.' . $request->image->getClientOriginalExtension();
            $dados['image']     = $request->image->storeAs('noticias', $nameFile);
        }
        $dados['url']       = Str::of($request->titulo)->slug('-');
        $evento->update($dados);

        return redirect()->back()->with('success', 'Evento atualizado com successo');
    }

    public function destroy($id)
    {
        $evento = Evento::find($id);
        $evento->delete();
        return redirect()->route('eventos.index')->with('success', 'Evento removido com successo');
    }
}
