<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Animal;
use App\Models\Empresa;
use App\Models\Atendimento;
use App\Models\AtendimentoInfo;
use App\Models\Especie;
use App\Models\Vacina;
use App\Models\Vacinacao;
use App\Models\Venda;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Mail;

class ClienteController extends Controller
{

    public function index()
    {
        if (Auth::user()->cliente == 0) {
            return view('acesso-negado');
        }
        $clientes = User::where('nivel', 4)->where('status','Ativo')->where('empresa_id',Auth::user()->empresa_id)->get();
        $TotalClientes = count($clientes);
        return view('admin.clientes.index', compact('clientes'), ['TotalClientes' => $TotalClientes]);
    }
    public function inativos()
    {
        if (Auth::user()->cliente == 0) {
            return view('acesso-negado');
        }
        $clientes = User::where('nivel', 4)->where('status','Inativo')->where('empresa_id',Auth::user()->empresa_id)->get();
        $TotalClientes = count($clientes);
        return view('admin.clientes.inativos', compact('clientes'), ['TotalClientes' => $TotalClientes]);
    }

    public function create()
    {
        return view('admin.clientes.create');
    }

    public function store(Request $request)
    {

        if (Auth::user()->cliente == 0) {
            return view('acesso-negado');
        }

        $user = User::where('email', $request->email)->where('empresa_id',Auth::user()->empresa_id)->first();
        if ($user) {
            return redirect()
                ->route('clientes.create')
                ->with('message', 'O E-mail já esta cadastrado');
        }

        $dados              = $request->all();
        $dados['nivel']     = 4;
        $dados['password']  = bcrypt($request->email);
        User::create($dados);

        Mail::send('email-boas-vindas-cliente', [
            'name' => $request->name,
            'email' => $request->email,
            'telefone' => $request->telefone,
            'assunto' => $request->assunto,
            'senha' => $request->email,
        ], function($mail) use($request){
            $mail->from(env('MAIL_FROM_ADDRESS'), env('APP_NAME'));
            $mail->to($request->email)->subject('Cadastro Clínica VET Care Bahia');
        });

        return redirect()
            ->route('cliente.perfil', User::find(DB::getPdo()->lastInsertId()))
            ->with('success', 'Cliente cadastrado com sucesso');
    }

    public function show($id)
    {
        if (Auth::user()->cliente == 0) {
            return view('acesso-negado');
        }
        $cliente            = User::find($id);
        $name               = explode(' ', $cliente->name);
        $animais            = Animal::where('cliente_id', $cliente->id)->get();
        $atendimentos       = Atendimento::where('cliente_id', $cliente->id)->get();
        $especies           = Especie::get();
        $totalAnimais       = count($animais);
        $totalAtendimentos  = count($atendimentos);
        $class              = 'resumo';
        $vendas             = Venda::where('cliente_id', $id)->where('tipo', 'Venda')->get();
        $total = 0;
        foreach ($vendas as $venda) {
            $total += $venda->total;
        }

        return view(
            'admin.clientes.show',
            compact(
                'name',
                'animais',
                'especies',
                'vendas'
            ),
            [
                'cliente'           => $cliente,
                'totalAnimais'      => $totalAnimais,
                'totalAtendimentos' => $totalAtendimentos,
                'class'             => $class,
                'total'             => $total
            ]
        );
    }

    public function AnimaisPerfil($id)
    {
        if (Auth::user()->cliente == 0) {
            return view('acesso-negado');
        }
        $cliente            = User::find($id);
        $name               = explode(' ', $cliente->name);
        $animais            = Animal::where('cliente_id', $cliente->id)->get();
        $especies           = Especie::get();
        $class              = 'animais';

        $atendimentos       = Atendimento::where('cliente_id', $cliente->id)->get();
        $totalAnimais       = count($animais);
        $totalAtendimentos  = count($atendimentos);
        $vendas             = Venda::where('cliente_id', $id)->where('tipo', 'Venda')->get();
        $total = 0;
        foreach ($vendas as $venda) {
            $total += $venda->total;
        }

        return view(
            'admin.clientes.animais',
            compact(
                'name',
                'animais',
                'especies',
            ),
            [
                'cliente'           => $cliente,
                'class'             => $class,
                'total'             => $total,
                'totalAnimais'      => $totalAnimais,
                'totalAtendimentos' => $totalAtendimentos,
            ]
        );
    }

    public function Protocolos($id)
    {
        if (Auth::user()->cliente == 0) {
            return view('acesso-negado');
        }
        $pro = 0;
        $dose = 0;
        $cliente            = User::find($id);
        $name               = explode(' ', $cliente->name);
        $animais            = Animal::where('cliente_id', $id)->get();
        $especies           = Especie::get();
        $class              = 'protocolos';
        $protocolos         = Vacina::where('cliente_id', $id)->with('protocolo', 'animal', 'user', 'tipo', 'vacinacao')->get();
        if(count($protocolos) > 0){
            foreach ($protocolos as $prot);
            $dose               = Vacinacao::where('vacina_id', $prot->id)->where('aplicacao', null)->orderby('id', 'Desc')->first();
        }
        $vendas             = Venda::where('cliente_id', $cliente->id)->where('tipo', 'Venda')->orderby('id', 'desc')->get();
        $atendimentos       = Atendimento::where('cliente_id', $cliente->id)->get();
        $totalAnimais       = count($animais);
        $totalAtendimentos  = count($atendimentos);
        $total = 0;
        foreach ($vendas as $venda) {
            $total += $venda->total;
        }

        $diaSemana = [
            "0" => 'Domingo',
            "1" => 'Segunda-feira',
            "2" => 'Terça-feira',
            "3" => 'Quarta-feira',
            "4" => 'Quinta-feira',
            "5" => 'Sexta-feira',
            "6" => 'Sábado',
        ];

        $mes = array(
            "01" => "janeiro",
            "1" => "janeiro",
            "02" => "fevereiro",
            "2" => "fevereiro",
            "03" => "março",
            "3" => "março",
            "04" => "abril",
            "4" => "abril",
            "05" => "maio",
            "5" => "maio",
            "06" => "junho",
            "6" => "junho",
            "07" => "julho",
            "7" => "julho",
            "08" => "agosto",
            "8" => "agosto",
            "09" => "setembro",
            "9" => "setembro",
            "10" => "outubro",
            "11" => "novembro",
            "12" => "dezembro"
        );

        return view(
            'admin.clientes.protocolos',
            compact(
                'name',
                'animais',
                'especies',
                'diaSemana',
                'mes',
                'protocolos',
            ),
            [
                'cliente'           => $cliente,
                'class'             => $class,
                'dose'              => $dose,
                'total'             => $total,
                'totalAnimais'      => $totalAnimais,
                'totalAtendimentos' => $totalAtendimentos,
            ]
        );
    }


    public function Atendimentos($id)
    {
        if (Auth::user()->cliente == 0) {
            return view('acesso-negado');
        }
        $cliente            = User::find($id);
        $name               = explode(' ', $cliente->name);
        $animais            = Animal::where('cliente_id', $cliente->id)->get();
        $especies           = Especie::get();
        $class              = 'atendimentos';
        $atendimentos       = Atendimento::where('cliente_id', $cliente->id)->get();
        $totalAnimais       = count($animais);
        $totalAtendimentos  = count($atendimentos);
        $vendas             = Venda::where('cliente_id', $id)->where('tipo', 'Venda')->get();
        $total = 0;
        foreach ($vendas as $venda) {
            $total += $venda->total;
        }
        $diaSemana = [
            "0" => 'Domingo',
            "1" => 'Segunda-feira',
            "2" => 'Terça-feira',
            "3" => 'Quarta-feira',
            "4" => 'Quinta-feira',
            "5" => 'Sexta-feira',
            "6" => 'Sábado',
        ];

        $mes = array(
            "01" => "janeiro",
            "1" => "janeiro",
            "02" => "fevereiro",
            "2" => "fevereiro",
            "03" => "março",
            "3" => "março",
            "04" => "abril",
            "4" => "abril",
            "05" => "maio",
            "5" => "maio",
            "06" => "junho",
            "6" => "junho",
            "07" => "julho",
            "7" => "julho",
            "08" => "agosto",
            "8" => "agosto",
            "09" => "setembro",
            "9" => "setembro",
            "10" => "outubro",
            "11" => "novembro",
            "12" => "dezembro"
        );

        return view(
            'admin.clientes.atendimentos',
            compact(
                'name',
                'animais',
                'especies',
                'atendimentos',
                'diaSemana',
                'mes',
            ),
            [
                'cliente'           => $cliente,
                'class'             => $class,
                'total'             => $total,
                'totalAnimais'      => $totalAnimais,
                'totalAtendimentos' => $totalAtendimentos,
            ]
        );
    }


    public function Vendas($id)
    {
        if (Auth::user()->cliente == 0) {
            return view('acesso-negado');
        }
        $cliente            = User::find($id);
        $name               = explode(' ', $cliente->name);
        $animais            = Animal::where('cliente_id', $cliente->id)->get();
        $especies           = Especie::get();
        $class              = 'vendas';
        $vendas             = Venda::where('cliente_id', $cliente->id)->where('tipo', 'Venda')->orderby('id', 'desc')->get();
        $atendimentos       = Atendimento::where('cliente_id', $cliente->id)->get();
        $totalAnimais       = count($animais);
        $totalAtendimentos  = count($atendimentos);
        $total = 0;
        foreach ($vendas as $venda) {
            $total += $venda->total;
        }

        $diaSemana = [
            "0" => 'Domingo',
            "1" => 'Segunda-feira',
            "2" => 'Terça-feira',
            "3" => 'Quarta-feira',
            "4" => 'Quinta-feira',
            "5" => 'Sexta-feira',
            "6" => 'Sábado',
        ];

        $mes = array(
            "01" => "janeiro",
            "1" => "janeiro",
            "02" => "fevereiro",
            "2" => "fevereiro",
            "03" => "março",
            "3" => "março",
            "04" => "abril",
            "4" => "abril",
            "05" => "maio",
            "5" => "maio",
            "06" => "junho",
            "6" => "junho",
            "07" => "julho",
            "7" => "julho",
            "08" => "agosto",
            "8" => "agosto",
            "09" => "setembro",
            "9" => "setembro",
            "10" => "outubro",
            "11" => "novembro",
            "12" => "dezembro"
        );

        return view(
            'admin.clientes.vendas',
            compact(
                'name',
                'animais',
                'especies',
                'vendas',
                'diaSemana',
                'mes',
            ),
            [
                'cliente'           => $cliente,
                'class'             => $class,
                'total'             => $total,
                'totalAnimais'      => $totalAnimais,
                'totalAtendimentos' => $totalAtendimentos,
            ]
        );
    }

    public function Orcametos($id)
    {
        if (Auth::user()->cliente == 0) {
            return view('acesso-negado');
        }
        $cliente            = User::find($id);
        $name               = explode(' ', $cliente->name);
        $animais            = Animal::where('cliente_id', $cliente->id)->get();
        $especies           = Especie::get();
        $class              = 'orcamentos';
        $vendas             = Venda::where('cliente_id', $cliente->id)->where('tipo', 'Orçamento')->orderby('id', 'desc')->get();
        $vendas             = Venda::where('cliente_id', $cliente->id)->where('tipo', 'Venda')->orderby('id', 'desc')->get();
        $atendimentos       = Atendimento::where('cliente_id', $cliente->id)->get();
        $totalAnimais       = count($animais);
        $totalAtendimentos  = count($atendimentos);
        $total = 0;
        foreach ($vendas as $venda) {
            $total += $venda->total;
        }

        $diaSemana = [
            "0" => 'Domingo',
            "1" => 'Segunda-feira',
            "2" => 'Terça-feira',
            "3" => 'Quarta-feira',
            "4" => 'Quinta-feira',
            "5" => 'Sexta-feira',
            "6" => 'Sábado',
        ];

        $mes = array(
            "01" => "janeiro",
            "1" => "janeiro",
            "02" => "fevereiro",
            "2" => "fevereiro",
            "03" => "março",
            "3" => "março",
            "04" => "abril",
            "4" => "abril",
            "05" => "maio",
            "5" => "maio",
            "06" => "junho",
            "6" => "junho",
            "07" => "julho",
            "7" => "julho",
            "08" => "agosto",
            "8" => "agosto",
            "09" => "setembro",
            "9" => "setembro",
            "10" => "outubro",
            "11" => "novembro",
            "12" => "dezembro"
        );

        return view(
            'admin.clientes.orcamentos',
            compact(
                'name',
                'animais',
                'especies',
                'vendas',
                'diaSemana',
                'mes',
            ),
            [
                'cliente'           => $cliente,
                'class'             => $class,
                'total'             => $total,
                'totalAnimais'      => $totalAnimais,
                'totalAtendimentos' => $totalAtendimentos,
            ]
        );
    }

    public function edit($id)
    {
        if (Auth::user()->cliente == 0) {
            return view('acesso-negado');
        }
        $cliente            = User::find($id);
        $name               = explode(' ', $cliente->name);
        $animais            = Animal::where('cliente_id', $cliente->id)->get();
        $especies           = Especie::get();
        $class              = 'dados';
        $vendas             = Venda::where('cliente_id', $cliente->id)->where('tipo', 'Venda')->orderby('id', 'desc')->get();
        $atendimentos       = Atendimento::where('cliente_id', $cliente->id)->get();
        $totalAnimais       = count($animais);
        $totalAtendimentos  = count($atendimentos);
        $total = 0;
        foreach ($vendas as $venda) {
            $total += $venda->total;
        }


        return view('admin.clientes.dados', compact(
            'name',
            'animais',
            'especies',
        ), [
            'cliente'           => $cliente,
            'class'             => $class,
            'total'             => $total,
            'totalAnimais'      => $totalAnimais,
            'totalAtendimentos' => $totalAtendimentos
        ]);
    }

    public function update(Request $request, $id)
    {
        if (Auth::user()->cliente == 0) {
            return view('acesso-negado');
        }
        if (!$cliente = User::find($id)) {
            return redirect()->back();
        }

        $user = User::where('email', $request->email)->get();
        if ($cliente->email != $request->email) {
            if (count($user) >= 1) {
                return redirect()
                    ->back()
                    ->with('message', 'O E-mail já esta cadastrado');
            }
        }

        $dados              = $request->all();
        $dados['status']    = $request->status == 'on' ? 'Ativo' : 'Inativo';


        $cliente->update($dados);
        return redirect()
            ->back()
            ->with('success', 'Dados atualizado com sucesso');
    }

    public function updateSelf(Request $request, $id)
    {
        if (Auth::user()->cliente == 0) {
            return view('acesso-negado');
        }
        if (!$cliente = User::find($id)) {
            return redirect()->back();
        }

        $nameFile       = Str::of('self')->slug('-').rand() . '.' . $request->foto->getClientOriginalExtension();
        $dados['foto']  = $request->foto->storeAs('self', $nameFile);

        $cliente->update($dados);
        return redirect()->back()->with('success', 'Dados atualizado com sucesso');
    }

    public function destroy($id)
    {
    }


    public function LoadEspecies(Request $request)
    {
        if (Auth::user()->cliente == 0) {
            return view('acesso-negado');
        }
        $dataForm   = $request->all();
        $especie    = $dataForm['especie'];
        $sql        = "SELECT * FROM racas WHERE especieID = '$especie'";
        $sql        = $sql . "order by raca asc";
        $racas      = DB::select($sql);
        return view('admin.ajax.racas', ['racas' => $racas]);
    }
}
